@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property creationInfos Single element list containing information on the creation permissions of the directory
 * @property path Path exposed as the root directory
 */
public data class GetAccessPointRootDirectory(
    public val creationInfos: List<GetAccessPointRootDirectoryCreationInfo>,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetAccessPointRootDirectory):
            GetAccessPointRootDirectory = GetAccessPointRootDirectory(
            creationInfos = javaType.creationInfos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.efs.kotlin.outputs.GetAccessPointRootDirectoryCreationInfo.Companion.toKotlin(args0)
                })
            }),
            path = javaType.path(),
        )
    }
}
