@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ownerGid POSIX owner group ID
 * @property ownerUid POSIX owner user ID
 * @property permissions POSIX permissions mode
 */
public data class GetAccessPointRootDirectoryCreationInfo(
    public val ownerGid: Int,
    public val ownerUid: Int,
    public val permissions: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetAccessPointRootDirectoryCreationInfo):
            GetAccessPointRootDirectoryCreationInfo = GetAccessPointRootDirectoryCreationInfo(
            ownerGid = javaType.ownerGid(),
            ownerUid = javaType.ownerUid(),
            permissions = javaType.permissions(),
        )
    }
}
