@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getFileSystem.
 * @property arn Amazon Resource Name of the file system.
 * @property availabilityZoneId The identifier of the Availability Zone in which the file system's One Zone storage classes exist.
 * @property availabilityZoneName The Availability Zone name in which the file system's One Zone storage classes exist.
 * @property creationToken
 * @property dnsName DNS name for the filesystem per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
 * @property encrypted Whether EFS is encrypted.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId ARN for the KMS encryption key.
 * @property lifecyclePolicy File system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object.
 * @property name The value of the file system's `Name` tag.
 * @property performanceMode File system performance mode.
 * @property provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for the file system.
 * @property sizeInBytes Current byte count used by the file system.
 * @property tags A map of tags to assign to the file system.
 * @property throughputMode Throughput mode for the file system.
 */
public data class GetFileSystemResult(
    public val arn: String,
    public val availabilityZoneId: String,
    public val availabilityZoneName: String,
    public val creationToken: String,
    public val dnsName: String,
    public val encrypted: Boolean,
    public val fileSystemId: String,
    public val id: String,
    public val kmsKeyId: String,
    public val lifecyclePolicy: GetFileSystemLifecyclePolicy,
    public val name: String,
    public val performanceMode: String,
    public val provisionedThroughputInMibps: Double,
    public val sizeInBytes: Int,
    public val tags: Map<String, String>,
    public val throughputMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetFileSystemResult):
            GetFileSystemResult = GetFileSystemResult(
            arn = javaType.arn(),
            availabilityZoneId = javaType.availabilityZoneId(),
            availabilityZoneName = javaType.availabilityZoneName(),
            creationToken = javaType.creationToken(),
            dnsName = javaType.dnsName(),
            encrypted = javaType.encrypted(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            lifecyclePolicy = javaType.lifecyclePolicy().let({ args0 ->
                com.pulumi.aws.efs.kotlin.outputs.GetFileSystemLifecyclePolicy.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            performanceMode = javaType.performanceMode(),
            provisionedThroughputInMibps = javaType.provisionedThroughputInMibps(),
            sizeInBytes = javaType.sizeInBytes(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughputMode = javaType.throughputMode(),
        )
    }
}
