@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getMountTarget.
 * @property accessPointId
 * @property availabilityZoneId The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in.
 * @property availabilityZoneName The name of the Availability Zone (AZ) that the mount target resides in.
 * @property dnsName DNS name for the EFS file system.
 * @property fileSystemArn Amazon Resource Name of the file system for which the mount target is intended.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipAddress Address at which the file system may be mounted via the mount target.
 * @property mountTargetDnsName The DNS name for the given subnet/AZ per [documented convention](http://docs.aws.amazon.com/efs/latest/ug/mounting-fs-mount-cmd-dns-name.html).
 * @property mountTargetId
 * @property networkInterfaceId The ID of the network interface that Amazon EFS created when it created the mount target.
 * @property ownerId AWS account ID that owns the resource.
 * @property securityGroups List of VPC security group IDs attached to the mount target.
 * @property subnetId ID of the mount target's subnet.
 */
public data class GetMountTargetResult(
    public val accessPointId: String? = null,
    public val availabilityZoneId: String,
    public val availabilityZoneName: String,
    public val dnsName: String,
    public val fileSystemArn: String,
    public val fileSystemId: String,
    public val id: String,
    public val ipAddress: String,
    public val mountTargetDnsName: String,
    public val mountTargetId: String,
    public val networkInterfaceId: String,
    public val ownerId: String,
    public val securityGroups: List<String>,
    public val subnetId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetMountTargetResult):
            GetMountTargetResult = GetMountTargetResult(
            accessPointId = javaType.accessPointId().map({ args0 -> args0 }).orElse(null),
            availabilityZoneId = javaType.availabilityZoneId(),
            availabilityZoneName = javaType.availabilityZoneName(),
            dnsName = javaType.dnsName(),
            fileSystemArn = javaType.fileSystemArn(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ipAddress = javaType.ipAddress(),
            mountTargetDnsName = javaType.mountTargetDnsName(),
            mountTargetId = javaType.mountTargetId(),
            networkInterfaceId = javaType.networkInterfaceId(),
            ownerId = javaType.ownerId(),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            subnetId = javaType.subnetId(),
        )
    }
}
