@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.ClusterCertificateAuthority
import com.pulumi.aws.eks.kotlin.outputs.ClusterEncryptionConfig
import com.pulumi.aws.eks.kotlin.outputs.ClusterIdentity
import com.pulumi.aws.eks.kotlin.outputs.ClusterKubernetesNetworkConfig
import com.pulumi.aws.eks.kotlin.outputs.ClusterOutpostConfig
import com.pulumi.aws.eks.kotlin.outputs.ClusterVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.eks.kotlin.outputs.ClusterCertificateAuthority.Companion.toKotlin as clusterCertificateAuthorityToKotlin
import com.pulumi.aws.eks.kotlin.outputs.ClusterEncryptionConfig.Companion.toKotlin as clusterEncryptionConfigToKotlin
import com.pulumi.aws.eks.kotlin.outputs.ClusterIdentity.Companion.toKotlin as clusterIdentityToKotlin
import com.pulumi.aws.eks.kotlin.outputs.ClusterKubernetesNetworkConfig.Companion.toKotlin as clusterKubernetesNetworkConfigToKotlin
import com.pulumi.aws.eks.kotlin.outputs.ClusterOutpostConfig.Companion.toKotlin as clusterOutpostConfigToKotlin
import com.pulumi.aws.eks.kotlin.outputs.ClusterVpcConfig.Companion.toKotlin as clusterVpcConfigToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.aws.eks.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Manages an EKS Cluster.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.Cluster;
 * import com.pulumi.aws.eks.ClusterArgs;
 * import com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example", ClusterArgs.builder()
 *             .roleArn(aws_iam_role.example().arn())
 *             .vpcConfig(ClusterVpcConfigArgs.builder()
 *                 .subnetIds(
 *                     aws_subnet.example1().id(),
 *                     aws_subnet.example2().id())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     aws_iam_role_policy_attachment.example-AmazonEKSClusterPolicy(),
 *                     aws_iam_role_policy_attachment.example-AmazonEKSVPCResourceController())
 *                 .build());
 *         ctx.export("endpoint", example.endpoint());
 *         ctx.export("kubeconfig-certificate-authority-data", example.certificateAuthority().applyValue(certificateAuthority -> certificateAuthority.data()));
 *     }
 * }
 * ```
 * ### Example IAM Role for EKS Cluster
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("eks.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var example_AmazonEKSClusterPolicy = new RolePolicyAttachment("example-AmazonEKSClusterPolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSClusterPolicy")
 *             .role(example.name())
 *             .build());
 *         var example_AmazonEKSVPCResourceController = new RolePolicyAttachment("example-AmazonEKSVPCResourceController", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSVPCResourceController")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ### Enabling Control Plane Logging
 * [EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) can be enabled via the `enabled_cluster_log_types` argument. To manage the CloudWatch Log Group retention period, the `aws.cloudwatch.LogGroup` resource can be used.
 * > The below configuration uses [`dependsOn`](https://www.pulumi.com/docs/intro/concepts/programming-model/#dependson) to prevent ordering issues with EKS automatically creating the log group first and a variable for naming consistency. Other ordering and naming methodologies may be more appropriate for your environment.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.cloudwatch.LogGroupArgs;
 * import com.pulumi.aws.eks.Cluster;
 * import com.pulumi.aws.eks.ClusterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var clusterName = config.get("clusterName").orElse("example");
 *         var exampleLogGroup = new LogGroup("exampleLogGroup", LogGroupArgs.builder()
 *             .retentionInDays(7)
 *             .build());
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .enabledClusterLogTypes(
 *                 "api",
 *                 "audit")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleLogGroup)
 *                 .build());
 *     }
 * }
 * ```
 * ### EKS Cluster on AWS Outpost
 * [Creating a local Amazon EKS cluster on an AWS Outpost](https://docs.aws.amazon.com/eks/latest/userguide/create-cluster-outpost.html)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.eks.Cluster;
 * import com.pulumi.aws.eks.ClusterArgs;
 * import com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs;
 * import com.pulumi.aws.eks.inputs.ClusterOutpostConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(data.aws_iam_policy_document().example_assume_role_policy().json())
 *             .build());
 *         var exampleCluster = new Cluster("exampleCluster", ClusterArgs.builder()
 *             .roleArn(exampleRole.arn())
 *             .vpcConfig(ClusterVpcConfigArgs.builder()
 *                 .endpointPrivateAccess(true)
 *                 .endpointPublicAccess(false)
 *                 .build())
 *             .outpostConfig(ClusterOutpostConfigArgs.builder()
 *                 .controlPlaneInstanceType("m5d.large")
 *                 .outpostArns(data.aws_outposts_outpost().example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Clusters using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:eks/cluster:Cluster my_cluster my_cluster
 * ```
 *
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.aws.eks.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * ARN of the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val certificateAuthorities: Output<List<ClusterCertificateAuthority>>
        get() = javaResource.certificateAuthorities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterCertificateAuthorityToKotlin(args0) })
            })
        })

    /**
     * Attribute block containing `certificate-authority-data` for your cluster. Detailed below.
     */
    public val certificateAuthority: Output<ClusterCertificateAuthority>
        get() = javaResource.certificateAuthority().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterCertificateAuthorityToKotlin(args0)
            })
        })

    /**
     * The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Unix epoch timestamp in seconds for when the cluster was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    public val defaultAddonsToRemoves: Output<List<String>>?
        get() = javaResource.defaultAddonsToRemoves().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * List of the desired control plane logging to enable. For more information, see [Amazon EKS Control Plane Logging](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html).
     */
    public val enabledClusterLogTypes: Output<List<String>>?
        get() = javaResource.enabledClusterLogTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Configuration block with encryption configuration for the cluster. Only available on Kubernetes 1.13 and above clusters created after March 6, 2020. Detailed below.
     */
    public val encryptionConfig: Output<ClusterEncryptionConfig>?
        get() = javaResource.encryptionConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterEncryptionConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Endpoint for your Kubernetes API server.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Attribute block containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. Detailed below.
     * * `kubernetes_network_config.service_ipv6_cidr` - The CIDR block that Kubernetes pod and service IP addresses are assigned from if you specified `ipv6` for ipFamily when you created the cluster. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
     */
    public val identities: Output<List<ClusterIdentity>>
        get() = javaResource.identities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterIdentityToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block with kubernetes network configuration for the cluster. Detailed below. If removed, this provider will only perform drift detection if a configuration value is provided.
     */
    public val kubernetesNetworkConfig: Output<ClusterKubernetesNetworkConfig>
        get() = javaResource.kubernetesNetworkConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterKubernetesNetworkConfigToKotlin(args0)
            })
        })

    /**
     * Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Configuration block representing the configuration of your local Amazon EKS cluster on an AWS Outpost. This block isn't available for creating Amazon EKS clusters on the AWS cloud.
     */
    public val outpostConfig: Output<ClusterOutpostConfig>?
        get() = javaResource.outpostConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> clusterOutpostConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Platform version for the cluster.
     */
    public val platformVersion: Output<String>
        get() = javaResource.platformVersion().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf. Ensure the resource configuration includes explicit dependencies on the IAM Role permissions by adding `depends_on` if using the `aws.iam.RolePolicy` resource or `aws.iam.RolePolicyAttachment` resource, otherwise EKS cannot delete EKS managed EC2 infrastructure such as Security Groups on EKS Cluster deletion.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Desired Kubernetes master version. If you do not specify a value, the latest available version at resource creation is used and no upgrades will occur except those automatically triggered by EKS. The value must be configured and increased to upgrade the version when desired. Downgrades are not supported by EKS.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the VPC associated with your cluster. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs&#46;aws&#46;amazon&#46;com/eks/latest/userguide/network_reqs&#46;html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the Amazon EKS User Guide. Detailed below. Also contains attributes detailed in the Attributes section.
     * The following arguments are optional:
     */
    public val vpcConfig: Output<ClusterVpcConfig>
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterVpcConfigToKotlin(args0)
            })
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.aws.eks.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit):
    Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
