@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.EksFunctions.getAddonPlain
import com.pulumi.aws.eks.EksFunctions.getAddonVersionPlain
import com.pulumi.aws.eks.EksFunctions.getClusterAuthPlain
import com.pulumi.aws.eks.EksFunctions.getClusterPlain
import com.pulumi.aws.eks.EksFunctions.getClustersPlain
import com.pulumi.aws.eks.EksFunctions.getNodeGroupPlain
import com.pulumi.aws.eks.EksFunctions.getNodeGroupsPlain
import com.pulumi.aws.eks.kotlin.inputs.GetAddonPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetAddonPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetAddonVersionPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetAddonVersionPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetClusterAuthPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetClusterAuthPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupsPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupsPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.outputs.GetAddonResult
import com.pulumi.aws.eks.kotlin.outputs.GetAddonVersionResult
import com.pulumi.aws.eks.kotlin.outputs.GetClusterAuthResult
import com.pulumi.aws.eks.kotlin.outputs.GetClusterResult
import com.pulumi.aws.eks.kotlin.outputs.GetClustersResult
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupResult
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.eks.kotlin.outputs.GetAddonResult.Companion.toKotlin as getAddonResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetAddonVersionResult.Companion.toKotlin as getAddonVersionResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClusterAuthResult.Companion.toKotlin as getClusterAuthResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupResult.Companion.toKotlin as getNodeGroupResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupsResult.Companion.toKotlin as getNodeGroupsResultToKotlin

public object EksFunctions {
    /**
     * Retrieve information about an EKS add-on.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName("vpc-cni")
     *             .clusterName(aws_eks_cluster.example().name())
     *             .build());
     *         ctx.export("eksAddonOutputs", aws_eks_addon.example());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAddon.
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(argument: GetAddonPlainArgs): GetAddonResult =
        getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())

    /**
     * @see [getAddon].
     * @param addonName Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     * @param clusterName Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * @param tags
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(
        addonName: String,
        clusterName: String,
        tags: Map<String, String>? = null,
    ): GetAddonResult {
        val argument = GetAddonPlainArgs(
            addonName = addonName,
            clusterName = clusterName,
            tags = tags,
        )
        return getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddon].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetAddonPlainArgs].
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(argument: suspend GetAddonPlainArgsBuilder.() -> Unit):
        GetAddonResult {
        val builder = GetAddonPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddonResultToKotlin(getAddonPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var defaultAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName("vpc-cni")
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .build());
     *         final var latestAddonVersion = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName("vpc-cni")
     *             .kubernetesVersion(aws_eks_cluster.example().version())
     *             .mostRecent(true)
     *             .build());
     *         var vpcCni = new Addon("vpcCni", AddonArgs.builder()
     *             .clusterName(aws_eks_cluster.example().name())
     *             .addonName("vpc-cni")
     *             .addonVersion(latestAddonVersion.applyValue(getAddonVersionResult -> getAddonVersionResult.version()))
     *             .build());
     *         ctx.export("default", defaultAddonVersion.applyValue(getAddonVersionResult -> getAddonVersionResult.version()));
     *         ctx.export("latest", latestAddonVersion.applyValue(getAddonVersionResult -> getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAddonVersion.
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(argument: GetAddonVersionPlainArgs): GetAddonVersionResult =
        getAddonVersionResultToKotlin(getAddonVersionPlain(argument.toJava()).await())

    /**
     * @see [getAddonVersion].
     * @param addonName Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     * @param kubernetesVersion Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * @param mostRecent Determines if the most recent or default version of the addon should be returned.
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(
        addonName: String,
        kubernetesVersion: String,
        mostRecent: Boolean? = null,
    ): GetAddonVersionResult {
        val argument = GetAddonVersionPlainArgs(
            addonName = addonName,
            kubernetesVersion = kubernetesVersion,
            mostRecent = mostRecent,
        )
        return getAddonVersionResultToKotlin(getAddonVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddonVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetAddonVersionPlainArgs].
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(argument: suspend GetAddonVersionPlainArgsBuilder.() -> Unit):
        GetAddonVersionResult {
        val builder = GetAddonVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddonVersionResultToKotlin(getAddonVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an EKS Cluster.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name("example")
     *             .build());
     *         ctx.export("endpoint", example.applyValue(getClusterResult -> getClusterResult.endpoint()));
     *         ctx.export("kubeconfig-certificate-authority-data", example.applyValue(getClusterResult -> getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export("identity-oidc-issuer", example.applyValue(getClusterResult -> getClusterResult.identities()[0].oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param name Name of the cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(name: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            name = name,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an authentication token to communicate with an EKS cluster.
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * @param argument A collection of arguments for invoking getClusterAuth.
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(argument: GetClusterAuthPlainArgs): GetClusterAuthResult =
        getClusterAuthResultToKotlin(getClusterAuthPlain(argument.toJava()).await())

    /**
     * @see [getClusterAuth].
     * @param name Name of the cluster
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(name: String): GetClusterAuthResult {
        val argument = GetClusterAuthPlainArgs(
            name = name,
        )
        return getClusterAuthResultToKotlin(getClusterAuthPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterAuth].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetClusterAuthPlainArgs].
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(argument: suspend GetClusterAuthPlainArgsBuilder.() -> Unit):
        GetClusterAuthResult {
        val builder = GetClusterAuthPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterAuthResultToKotlin(getClusterAuthPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve EKS Clusters list
     * @param argument Retrieve EKS Clusters list
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain().await())

    /**
     * Retrieve information about an EKS Node Group.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName("example")
     *             .nodeGroupName("example")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNodeGroup.
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(argument: GetNodeGroupPlainArgs): GetNodeGroupResult =
        getNodeGroupResultToKotlin(getNodeGroupPlain(argument.toJava()).await())

    /**
     * @see [getNodeGroup].
     * @param clusterName Name of the cluster.
     * @param nodeGroupName Name of the node group.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(
        clusterName: String,
        nodeGroupName: String,
        tags: Map<String, String>? = null,
    ): GetNodeGroupResult {
        val argument = GetNodeGroupPlainArgs(
            clusterName = clusterName,
            nodeGroupName = nodeGroupName,
            tags = tags,
        )
        return getNodeGroupResultToKotlin(getNodeGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetNodeGroupPlainArgs].
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(argument: suspend GetNodeGroupPlainArgsBuilder.() -> Unit):
        GetNodeGroupResult {
        val builder = GetNodeGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeGroupResultToKotlin(getNodeGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * ## Example Usage
     * No Java example available.
     * @param argument A collection of arguments for invoking getNodeGroups.
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(argument: GetNodeGroupsPlainArgs): GetNodeGroupsResult =
        getNodeGroupsResultToKotlin(getNodeGroupsPlain(argument.toJava()).await())

    /**
     * @see [getNodeGroups].
     * @param clusterName Name of the cluster.
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(clusterName: String): GetNodeGroupsResult {
        val argument = GetNodeGroupsPlainArgs(
            clusterName = clusterName,
        )
        return getNodeGroupsResultToKotlin(getNodeGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetNodeGroupsPlainArgs].
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(argument: suspend GetNodeGroupsPlainArgsBuilder.() -> Unit):
        GetNodeGroupsResult {
        val builder = GetNodeGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeGroupsResultToKotlin(getNodeGroupsPlain(builtArgument.toJava()).await())
    }
}
