@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.FargateProfileSelector
import com.pulumi.aws.eks.kotlin.outputs.FargateProfileSelector.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [FargateProfile].
 */
@PulumiTagMarker
public class FargateProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FargateProfileArgs = FargateProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FargateProfileArgsBuilder.() -> Unit) {
        val builder = FargateProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FargateProfile {
        val builtJavaResource = com.pulumi.aws.eks.FargateProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FargateProfile(builtJavaResource)
    }
}

/**
 * Manages an EKS Fargate Profile.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.FargateProfile;
 * import com.pulumi.aws.eks.FargateProfileArgs;
 * import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FargateProfile("example", FargateProfileArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .podExecutionRoleArn(aws_iam_role.example().arn())
 *             .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *             .selectors(FargateProfileSelectorArgs.builder()
 *                 .namespace("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for EKS Fargate Profile
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "eks-fargate-pods.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSFargatePodExecutionRolePolicy = new RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Fargate Profiles using the `cluster_name` and `fargate_profile_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/fargateProfile:FargateProfile my_fargate_profile my_cluster:my_fargate_profile
 * ```
 *
 */
public class FargateProfile internal constructor(
    override val javaResource: com.pulumi.aws.eks.FargateProfile,
) : KotlinCustomResource(javaResource, FargateProfileMapper) {
    /**
     * Amazon Resource Name (ARN) of the EKS Fargate Profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Fargate Profile.
     */
    public val fargateProfileName: Output<String>
        get() = javaResource.fargateProfileName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    public val podExecutionRoleArn: Output<String>
        get() = javaResource.podExecutionRoleArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    public val selectors: Output<List<FargateProfileSelector>>
        get() = javaResource.selectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Status of the EKS Fargate Profile.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>?
        get() = javaResource.subnetIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FargateProfileMapper : ResourceMapper<FargateProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.FargateProfile::class == javaResource::class

    override fun map(javaResource: Resource): FargateProfile = FargateProfile(
        javaResource as
            com.pulumi.aws.eks.FargateProfile,
    )
}

/**
 * @see [FargateProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FargateProfile].
 */
public suspend fun fargateProfile(
    name: String,
    block: suspend FargateProfileResourceBuilder.() -> Unit,
): FargateProfile {
    val builder = FargateProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FargateProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fargateProfile(name: String): FargateProfile {
    val builder = FargateProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
