@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.FargateProfileArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.FargateProfileSelectorArgs
import com.pulumi.aws.eks.kotlin.inputs.FargateProfileSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EKS Fargate Profile.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.FargateProfile;
 * import com.pulumi.aws.eks.FargateProfileArgs;
 * import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FargateProfile("example", FargateProfileArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .podExecutionRoleArn(aws_iam_role.example().arn())
 *             .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *             .selectors(FargateProfileSelectorArgs.builder()
 *                 .namespace("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for EKS Fargate Profile
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "eks-fargate-pods.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSFargatePodExecutionRolePolicy = new RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Fargate Profiles using the `cluster_name` and `fargate_profile_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/fargateProfile:FargateProfile my_fargate_profile my_cluster:my_fargate_profile
 * ```
 * @property clusterName Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
 * @property fargateProfileName Name of the EKS Fargate Profile.
 * @property podExecutionRoleArn Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
 * @property selectors Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
 * @property subnetIds Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FargateProfileArgs(
    public val clusterName: Output<String>? = null,
    public val fargateProfileName: Output<String>? = null,
    public val podExecutionRoleArn: Output<String>? = null,
    public val selectors: Output<List<FargateProfileSelectorArgs>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.FargateProfileArgs> {
    override fun toJava(): com.pulumi.aws.eks.FargateProfileArgs =
        com.pulumi.aws.eks.FargateProfileArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .fargateProfileName(fargateProfileName?.applyValue({ args0 -> args0 }))
            .podExecutionRoleArn(podExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .selectors(
                selectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FargateProfileArgs].
 */
@PulumiTagMarker
public class FargateProfileArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var fargateProfileName: Output<String>? = null

    private var podExecutionRoleArn: Output<String>? = null

    private var selectors: Output<List<FargateProfileSelectorArgs>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    @JvmName("pdlmlsrlbwvxwfgq")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Name of the EKS Fargate Profile.
     */
    @JvmName("pcasajhwwefxcjqs")
    public suspend fun fargateProfileName(`value`: Output<String>) {
        this.fargateProfileName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    @JvmName("askyokxufodxhoyh")
    public suspend fun podExecutionRoleArn(`value`: Output<String>) {
        this.podExecutionRoleArn = value
    }

    /**
     * @param value Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("pthcamromimsqpmi")
    public suspend fun selectors(`value`: Output<List<FargateProfileSelectorArgs>>) {
        this.selectors = value
    }

    @JvmName("rvkvjuunhaqgaafj")
    public suspend fun selectors(vararg values: Output<FargateProfileSelectorArgs>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("vyalhacbjsskupeo")
    public suspend fun selectors(values: List<Output<FargateProfileSelectorArgs>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("xclqkabokkfnqtse")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("rcxgonkmivwsfxxw")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("bugghcmvffdlqong")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nsxutqevsidqbyer")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    @JvmName("damjyqijvvismoht")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the EKS Fargate Profile.
     */
    @JvmName("bfgledifnnjpbcan")
    public suspend fun fargateProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fargateProfileName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    @JvmName("okluyehkxvqoraqb")
    public suspend fun podExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podExecutionRoleArn = mapped
    }

    /**
     * @param value Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("moblbpqbblbvjgju")
    public suspend fun selectors(`value`: List<FargateProfileSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("dtxgyvkqdxywntpk")
    public suspend
    fun selectors(argument: List<suspend FargateProfileSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FargateProfileSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("teqaqucjtgoekcfp")
    public suspend fun selectors(
        vararg
        argument: suspend FargateProfileSelectorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FargateProfileSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("bofowjapanyjyhep")
    public suspend fun selectors(argument: suspend FargateProfileSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FargateProfileSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param values Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("xcgoujwkmwfvalnj")
    public suspend fun selectors(vararg values: FargateProfileSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param value Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("mlrlkkltpocjbqlu")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("pqfhbiuvapkxpkum")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uwtrythufmrvxhle")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pivxmeialojgwvgf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FargateProfileArgs = FargateProfileArgs(
        clusterName = clusterName,
        fargateProfileName = fargateProfileName,
        podExecutionRoleArn = podExecutionRoleArn,
        selectors = selectors,
        subnetIds = subnetIds,
        tags = tags,
    )
}
