@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.IdentityProviderConfigOidc
import com.pulumi.aws.eks.kotlin.outputs.IdentityProviderConfigOidc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [IdentityProviderConfig].
 */
@PulumiTagMarker
public class IdentityProviderConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IdentityProviderConfigArgs = IdentityProviderConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IdentityProviderConfigArgsBuilder.() -> Unit) {
        val builder = IdentityProviderConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IdentityProviderConfig {
        val builtJavaResource = com.pulumi.aws.eks.IdentityProviderConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IdentityProviderConfig(builtJavaResource)
    }
}

/**
 * Manages an EKS Identity Provider Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.IdentityProviderConfig;
 * import com.pulumi.aws.eks.IdentityProviderConfigArgs;
 * import com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IdentityProviderConfig("example", IdentityProviderConfigArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .oidc(IdentityProviderConfigOidcArgs.builder()
 *                 .clientId("your client_id")
 *                 .identityProviderConfigName("example")
 *                 .issuerUrl("your issuer_url")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Identity Provider Configurations using the `cluster_name` and `identity_provider_config_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/identityProviderConfig:IdentityProviderConfig my_identity_provider_config my_cluster:my_identity_provider_config
 * ```
 *
 */
public class IdentityProviderConfig internal constructor(
    override val javaResource: com.pulumi.aws.eks.IdentityProviderConfig,
) : KotlinCustomResource(javaResource, IdentityProviderConfigMapper) {
    /**
     * Amazon Resource Name (ARN) of the EKS Identity Provider Configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    public val oidc: Output<IdentityProviderConfigOidc>
        get() = javaResource.oidc().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Status of the EKS Identity Provider Configuration.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IdentityProviderConfigMapper : ResourceMapper<IdentityProviderConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.IdentityProviderConfig::class == javaResource::class

    override fun map(javaResource: Resource): IdentityProviderConfig =
        IdentityProviderConfig(javaResource as com.pulumi.aws.eks.IdentityProviderConfig)
}

/**
 * @see [IdentityProviderConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IdentityProviderConfig].
 */
public suspend fun identityProviderConfig(
    name: String,
    block: suspend IdentityProviderConfigResourceBuilder.() -> Unit,
): IdentityProviderConfig {
    val builder = IdentityProviderConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IdentityProviderConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun identityProviderConfig(name: String): IdentityProviderConfig {
    val builder = IdentityProviderConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
