@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.IdentityProviderConfigArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.IdentityProviderConfigOidcArgs
import com.pulumi.aws.eks.kotlin.inputs.IdentityProviderConfigOidcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EKS Identity Provider Configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.IdentityProviderConfig;
 * import com.pulumi.aws.eks.IdentityProviderConfigArgs;
 * import com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IdentityProviderConfig("example", IdentityProviderConfigArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .oidc(IdentityProviderConfigOidcArgs.builder()
 *                 .clientId("your client_id")
 *                 .identityProviderConfigName("example")
 *                 .issuerUrl("your issuer_url")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Identity Provider Configurations using the `cluster_name` and `identity_provider_config_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/identityProviderConfig:IdentityProviderConfig my_identity_provider_config my_cluster:my_identity_provider_config
 * ```
 * @property clusterName Name of the EKS Cluster.
 * @property oidc Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IdentityProviderConfigArgs(
    public val clusterName: Output<String>? = null,
    public val oidc: Output<IdentityProviderConfigOidcArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.IdentityProviderConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.IdentityProviderConfigArgs =
        com.pulumi.aws.eks.IdentityProviderConfigArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .oidc(oidc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IdentityProviderConfigArgs].
 */
@PulumiTagMarker
public class IdentityProviderConfigArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var oidc: Output<IdentityProviderConfigOidcArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("fprjxykuxkwdsynt")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("scjqgbcjppqfalbo")
    public suspend fun oidc(`value`: Output<IdentityProviderConfigOidcArgs>) {
        this.oidc = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("davmwlcvrlruepbw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("qshcbniadaqgxmyb")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("qrlyawcekjgoaekj")
    public suspend fun oidc(`value`: IdentityProviderConfigOidcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidc = mapped
    }

    /**
     * @param argument Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("toltsbubnkkwymns")
    public suspend fun oidc(argument: suspend IdentityProviderConfigOidcArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderConfigOidcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidc = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("chohmcgrrnaljwuk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kmqjuuosobuiatgp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IdentityProviderConfigArgs = IdentityProviderConfigArgs(
        clusterName = clusterName,
        oidc = oidc,
        tags = tags,
    )
}
