@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.NodeGroupLaunchTemplate
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupRemoteAccess
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupResource
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupScalingConfig
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupTaint
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupUpdateConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupLaunchTemplate.Companion.toKotlin as nodeGroupLaunchTemplateToKotlin
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupRemoteAccess.Companion.toKotlin as nodeGroupRemoteAccessToKotlin
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupResource.Companion.toKotlin as nodeGroupResourceToKotlin
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupScalingConfig.Companion.toKotlin as nodeGroupScalingConfigToKotlin
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupTaint.Companion.toKotlin as nodeGroupTaintToKotlin
import com.pulumi.aws.eks.kotlin.outputs.NodeGroupUpdateConfig.Companion.toKotlin as nodeGroupUpdateConfigToKotlin

/**
 * Builder for [NodeGroup].
 */
@PulumiTagMarker
public class NodeGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NodeGroupArgs = NodeGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NodeGroupArgsBuilder.() -> Unit) {
        val builder = NodeGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NodeGroup {
        val builtJavaResource = com.pulumi.aws.eks.NodeGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NodeGroup(builtJavaResource)
    }
}

/**
 * Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.NodeGroup;
 * import com.pulumi.aws.eks.NodeGroupArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NodeGroup("example", NodeGroupArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .nodeRoleArn(aws_iam_role.example().arn())
 *             .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *             .scalingConfig(NodeGroupScalingConfigArgs.builder()
 *                 .desiredSize(1)
 *                 .maxSize(2)
 *                 .minSize(1)
 *                 .build())
 *             .updateConfig(NodeGroupUpdateConfigArgs.builder()
 *                 .maxUnavailable(1)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     aws_iam_role_policy_attachment.example-AmazonEKSWorkerNodePolicy(),
 *                     aws_iam_role_policy_attachment.example-AmazonEKS_CNI_Policy(),
 *                     aws_iam_role_policy_attachment.example-AmazonEC2ContainerRegistryReadOnly())
 *                 .build());
 *     }
 * }
 * ```
 * ### Ignoring Changes to Desired Size
 * You can utilize [ignoreChanges](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) create an EKS Node Group with an initial size of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.NodeGroup;
 * import com.pulumi.aws.eks.NodeGroupArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NodeGroup("example", NodeGroupArgs.builder()
 *             .scalingConfig(NodeGroupScalingConfigArgs.builder()
 *                 .desiredSize(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for EKS Node Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSWorkerNodePolicy = new RolePolicyAttachment("example-AmazonEKSWorkerNodePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
 *             .role(example.name())
 *             .build());
 *         var example_AmazonEKSCNIPolicy = new RolePolicyAttachment("example-AmazonEKSCNIPolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
 *             .role(example.name())
 *             .build());
 *         var example_AmazonEC2ContainerRegistryReadOnly = new RolePolicyAttachment("example-AmazonEC2ContainerRegistryReadOnly", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Node Groups using the `cluster_name` and `node_group_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/nodeGroup:NodeGroup my_node_group my_cluster:my_node_group
 * ```
 *
 */
public class NodeGroup internal constructor(
    override val javaResource: com.pulumi.aws.eks.NodeGroup,
) : KotlinCustomResource(javaResource, NodeGroupMapper) {
    /**
     * Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
     */
    public val amiType: Output<String>
        get() = javaResource.amiType().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the EKS Node Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
     */
    public val capacityType: Output<String>
        get() = javaResource.capacityType().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
     */
    public val diskSize: Output<Int>
        get() = javaResource.diskSize().applyValue({ args0 -> args0 })

    /**
     * Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
     */
    public val forceUpdateVersion: Output<Boolean>?
        get() = javaResource.forceUpdateVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
     */
    public val instanceTypes: Output<List<String>>
        get() = javaResource.instanceTypes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
     */
    public val labels: Output<Map<String, String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Configuration block with Launch Template settings. See `launch_template` below for details.
     */
    public val launchTemplate: Output<NodeGroupLaunchTemplate>?
        get() = javaResource.launchTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeGroupLaunchTemplateToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
     */
    public val nodeGroupName: Output<String>
        get() = javaResource.nodeGroupName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
     */
    public val nodeGroupNamePrefix: Output<String>
        get() = javaResource.nodeGroupNamePrefix().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
     */
    public val nodeRoleArn: Output<String>
        get() = javaResource.nodeRoleArn().applyValue({ args0 -> args0 })

    /**
     * AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
     */
    public val releaseVersion: Output<String>
        get() = javaResource.releaseVersion().applyValue({ args0 -> args0 })

    /**
     * Configuration block with remote access settings. See `remote_access` below for details.
     */
    public val remoteAccess: Output<NodeGroupRemoteAccess>?
        get() = javaResource.remoteAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nodeGroupRemoteAccessToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of objects containing information about underlying resources.
     */
    public val resources: Output<List<NodeGroupResource>>
        get() = javaResource.resources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nodeGroupResourceToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block with scaling settings. See `scaling_config` below for details.
     */
    public val scalingConfig: Output<NodeGroupScalingConfig>
        get() = javaResource.scalingConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                nodeGroupScalingConfigToKotlin(args0)
            })
        })

    /**
     * Status of the EKS Node Group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Identifiers of EC2 Subnets to associate with the EKS Node Group.
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    public val taints: Output<List<NodeGroupTaint>>?
        get() = javaResource.taints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nodeGroupTaintToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Configuration block with update settings. See `update_config` below for details.
     */
    public val updateConfig: Output<NodeGroupUpdateConfig>
        get() = javaResource.updateConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                nodeGroupUpdateConfigToKotlin(args0)
            })
        })

    /**
     * Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object NodeGroupMapper : ResourceMapper<NodeGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.NodeGroup::class == javaResource::class

    override fun map(javaResource: Resource): NodeGroup = NodeGroup(
        javaResource as
            com.pulumi.aws.eks.NodeGroup,
    )
}

/**
 * @see [NodeGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NodeGroup].
 */
public suspend fun nodeGroup(name: String, block: suspend NodeGroupResourceBuilder.() -> Unit):
    NodeGroup {
    val builder = NodeGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NodeGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun nodeGroup(name: String): NodeGroup {
    val builder = NodeGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
