@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.NodeGroupArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupLaunchTemplateArgs
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupLaunchTemplateArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupRemoteAccessArgs
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupRemoteAccessArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupScalingConfigArgs
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupScalingConfigArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupTaintArgs
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupTaintArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupUpdateConfigArgs
import com.pulumi.aws.eks.kotlin.inputs.NodeGroupUpdateConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EKS Node Group, which can provision and optionally update an Auto Scaling Group of Kubernetes worker nodes compatible with EKS. Additional documentation about this functionality can be found in the [EKS User Guide](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.NodeGroup;
 * import com.pulumi.aws.eks.NodeGroupArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NodeGroup("example", NodeGroupArgs.builder()
 *             .clusterName(aws_eks_cluster.example().name())
 *             .nodeRoleArn(aws_iam_role.example().arn())
 *             .subnetIds(aws_subnet.example().stream().map(element -> element.id()).collect(toList()))
 *             .scalingConfig(NodeGroupScalingConfigArgs.builder()
 *                 .desiredSize(1)
 *                 .maxSize(2)
 *                 .minSize(1)
 *                 .build())
 *             .updateConfig(NodeGroupUpdateConfigArgs.builder()
 *                 .maxUnavailable(1)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     aws_iam_role_policy_attachment.example-AmazonEKSWorkerNodePolicy(),
 *                     aws_iam_role_policy_attachment.example-AmazonEKS_CNI_Policy(),
 *                     aws_iam_role_policy_attachment.example-AmazonEC2ContainerRegistryReadOnly())
 *                 .build());
 *     }
 * }
 * ```
 * ### Ignoring Changes to Desired Size
 * You can utilize [ignoreChanges](https://www.pulumi.com/docs/intro/concepts/programming-model/#ignorechanges) create an EKS Node Group with an initial size of running instances, then ignore any changes to that count caused externally (e.g. Application Autoscaling).
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.NodeGroup;
 * import com.pulumi.aws.eks.NodeGroupArgs;
 * import com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NodeGroup("example", NodeGroupArgs.builder()
 *             .scalingConfig(NodeGroupScalingConfigArgs.builder()
 *                 .desiredSize(2)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Example IAM Role for EKS Node Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSWorkerNodePolicy = new RolePolicyAttachment("example-AmazonEKSWorkerNodePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSWorkerNodePolicy")
 *             .role(example.name())
 *             .build());
 *         var example_AmazonEKSCNIPolicy = new RolePolicyAttachment("example-AmazonEKSCNIPolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKS_CNI_Policy")
 *             .role(example.name())
 *             .build());
 *         var example_AmazonEC2ContainerRegistryReadOnly = new RolePolicyAttachment("example-AmazonEC2ContainerRegistryReadOnly", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEC2ContainerRegistryReadOnly")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EKS Node Groups using the `cluster_name` and `node_group_name` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:eks/nodeGroup:NodeGroup my_node_group my_cluster:my_node_group
 * ```
 * @property amiType Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
 * @property capacityType Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
 * @property clusterName Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
 * @property diskSize Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
 * @property forceUpdateVersion Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
 * @property instanceTypes List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
 * @property labels Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
 * @property launchTemplate Configuration block with Launch Template settings. See `launch_template` below for details.
 * @property nodeGroupName Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
 * @property nodeGroupNamePrefix Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
 * @property nodeRoleArn Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
 * @property releaseVersion AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
 * @property remoteAccess Configuration block with remote access settings. See `remote_access` below for details.
 * @property scalingConfig Configuration block with scaling settings. See `scaling_config` below for details.
 * @property subnetIds Identifiers of EC2 Subnets to associate with the EKS Node Group.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property taints The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
 * @property updateConfig Configuration block with update settings. See `update_config` below for details.
 * @property version Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
 */
public data class NodeGroupArgs(
    public val amiType: Output<String>? = null,
    public val capacityType: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val forceUpdateVersion: Output<Boolean>? = null,
    public val instanceTypes: Output<List<String>>? = null,
    public val labels: Output<Map<String, String>>? = null,
    public val launchTemplate: Output<NodeGroupLaunchTemplateArgs>? = null,
    public val nodeGroupName: Output<String>? = null,
    public val nodeGroupNamePrefix: Output<String>? = null,
    public val nodeRoleArn: Output<String>? = null,
    public val releaseVersion: Output<String>? = null,
    public val remoteAccess: Output<NodeGroupRemoteAccessArgs>? = null,
    public val scalingConfig: Output<NodeGroupScalingConfigArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val taints: Output<List<NodeGroupTaintArgs>>? = null,
    public val updateConfig: Output<NodeGroupUpdateConfigArgs>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.NodeGroupArgs> {
    override fun toJava(): com.pulumi.aws.eks.NodeGroupArgs =
        com.pulumi.aws.eks.NodeGroupArgs.builder()
            .amiType(amiType?.applyValue({ args0 -> args0 }))
            .capacityType(capacityType?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .forceUpdateVersion(forceUpdateVersion?.applyValue({ args0 -> args0 }))
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .nodeGroupName(nodeGroupName?.applyValue({ args0 -> args0 }))
            .nodeGroupNamePrefix(nodeGroupNamePrefix?.applyValue({ args0 -> args0 }))
            .nodeRoleArn(nodeRoleArn?.applyValue({ args0 -> args0 }))
            .releaseVersion(releaseVersion?.applyValue({ args0 -> args0 }))
            .remoteAccess(remoteAccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scalingConfig(scalingConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .taints(taints?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .updateConfig(updateConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupArgs].
 */
@PulumiTagMarker
public class NodeGroupArgsBuilder internal constructor() {
    private var amiType: Output<String>? = null

    private var capacityType: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var forceUpdateVersion: Output<Boolean>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var labels: Output<Map<String, String>>? = null

    private var launchTemplate: Output<NodeGroupLaunchTemplateArgs>? = null

    private var nodeGroupName: Output<String>? = null

    private var nodeGroupNamePrefix: Output<String>? = null

    private var nodeRoleArn: Output<String>? = null

    private var releaseVersion: Output<String>? = null

    private var remoteAccess: Output<NodeGroupRemoteAccessArgs>? = null

    private var scalingConfig: Output<NodeGroupScalingConfigArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var taints: Output<List<NodeGroupTaintArgs>>? = null

    private var updateConfig: Output<NodeGroupUpdateConfigArgs>? = null

    private var version: Output<String>? = null

    /**
     * @param value Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("atohviqudlvudoie")
    public suspend fun amiType(`value`: Output<String>) {
        this.amiType = value
    }

    /**
     * @param value Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("ckuabfrvhvarrtlc")
    public suspend fun capacityType(`value`: Output<String>) {
        this.capacityType = value
    }

    /**
     * @param value Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    @JvmName("apmkoyikroucqglb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("cjaacfvhwusiiibl")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
     */
    @JvmName("yqlnffwshwvmqpgv")
    public suspend fun forceUpdateVersion(`value`: Output<Boolean>) {
        this.forceUpdateVersion = value
    }

    /**
     * @param value List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("qpgvafxodcgckguw")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("tdbllvanyvonfgek")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("euvkgqmjrhqpusge")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
     */
    @JvmName("lxerjsekdamtvmun")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Configuration block with Launch Template settings. See `launch_template` below for details.
     */
    @JvmName("lqmbuivbksqfqoux")
    public suspend fun launchTemplate(`value`: Output<NodeGroupLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
     */
    @JvmName("tryycbfsanjkaoml")
    public suspend fun nodeGroupName(`value`: Output<String>) {
        this.nodeGroupName = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
     */
    @JvmName("nxevuwvxbjmjwixh")
    public suspend fun nodeGroupNamePrefix(`value`: Output<String>) {
        this.nodeGroupNamePrefix = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
     */
    @JvmName("wisjhiavgiakrdfp")
    public suspend fun nodeRoleArn(`value`: Output<String>) {
        this.nodeRoleArn = value
    }

    /**
     * @param value AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
     */
    @JvmName("gkvjcvledexldyio")
    public suspend fun releaseVersion(`value`: Output<String>) {
        this.releaseVersion = value
    }

    /**
     * @param value Configuration block with remote access settings. See `remote_access` below for details.
     */
    @JvmName("dwswhqimswbpjyga")
    public suspend fun remoteAccess(`value`: Output<NodeGroupRemoteAccessArgs>) {
        this.remoteAccess = value
    }

    /**
     * @param value Configuration block with scaling settings. See `scaling_config` below for details.
     */
    @JvmName("inokduydcbjsobps")
    public suspend fun scalingConfig(`value`: Output<NodeGroupScalingConfigArgs>) {
        this.scalingConfig = value
    }

    /**
     * @param value Identifiers of EC2 Subnets to associate with the EKS Node Group.
     * The following arguments are optional:
     */
    @JvmName("kfikvhfgiiddctrw")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("normclnguynxqepg")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of EC2 Subnets to associate with the EKS Node Group.
     * The following arguments are optional:
     */
    @JvmName("hjrrbtydeqntmrsl")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yibxrwkaqkohremt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("vqsmfqjnujjsftql")
    public suspend fun taints(`value`: Output<List<NodeGroupTaintArgs>>) {
        this.taints = value
    }

    @JvmName("xgkomudxfxtgghgj")
    public suspend fun taints(vararg values: Output<NodeGroupTaintArgs>) {
        this.taints = Output.all(values.asList())
    }

    /**
     * @param values The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("scggtijapvpxsoka")
    public suspend fun taints(values: List<Output<NodeGroupTaintArgs>>) {
        this.taints = Output.all(values)
    }

    /**
     * @param value Configuration block with update settings. See `update_config` below for details.
     */
    @JvmName("oaegumvbvjpumywk")
    public suspend fun updateConfig(`value`: Output<NodeGroupUpdateConfigArgs>) {
        this.updateConfig = value
    }

    /**
     * @param value Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("ciuxyiwadopxbexi")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Type of Amazon Machine Image (AMI) associated with the EKS Node Group. See the [AWS documentation](https://docs.aws.amazon.com/eks/latest/APIReference/API_Nodegroup.html#AmazonEKS-Type-Nodegroup-amiType) for valid values. This provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("qhybkjrudrdvonhm")
    public suspend fun amiType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amiType = mapped
    }

    /**
     * @param value Type of capacity associated with the EKS Node Group. Valid values: `ON_DEMAND`, `SPOT`. This provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("andkfracyngehpnc")
    public suspend fun capacityType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityType = mapped
    }

    /**
     * @param value Name of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    @JvmName("ibvknruwoddpecxd")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Disk size in GiB for worker nodes. Defaults to `50` for Windows, `20` all other node groups. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("hbxpmbblrqddncmp")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value Force version update if existing pods are unable to be drained due to a pod disruption budget issue.
     */
    @JvmName("edebkcuejgusrcas")
    public suspend fun forceUpdateVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateVersion = mapped
    }

    /**
     * @param value List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("bqluwkafknrywdkm")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values List of instance types associated with the EKS Node Group. Defaults to `["t3&#46;medium"]`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("rgvpjgvukxafyjvv")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
     */
    @JvmName("jemuuewojigoqqqq")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Key-value map of Kubernetes labels. Only labels that are applied with the EKS API are managed by this argument. Other Kubernetes labels applied to the EKS Node Group will not be managed.
     */
    @JvmName("qxixcqegcrwpkggu")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Configuration block with Launch Template settings. See `launch_template` below for details.
     */
    @JvmName("eldjoxyfblhxjljk")
    public suspend fun launchTemplate(`value`: NodeGroupLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Configuration block with Launch Template settings. See `launch_template` below for details.
     */
    @JvmName("qkwdwylcuidudfgp")
    public suspend
    fun launchTemplate(argument: suspend NodeGroupLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = NodeGroupLaunchTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value Name of the EKS Node Group. If omitted, the provider will assign a random, unique name. Conflicts with `node_group_name_prefix`. The node group name can't be longer than 63 characters. It must start with a letter or digit, but can also include hyphens and underscores for the remaining characters.
     */
    @JvmName("lwfmmejkwettukjv")
    public suspend fun nodeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupName = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `node_group_name`.
     */
    @JvmName("kcdfrmrkswndqwly")
    public suspend fun nodeGroupNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeGroupNamePrefix = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Node Group.
     */
    @JvmName("nufipbxsntaafhyl")
    public suspend fun nodeRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeRoleArn = mapped
    }

    /**
     * @param value AMI version of the EKS Node Group. Defaults to latest version for Kubernetes version.
     */
    @JvmName("ufchhdxergmaglky")
    public suspend fun releaseVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseVersion = mapped
    }

    /**
     * @param value Configuration block with remote access settings. See `remote_access` below for details.
     */
    @JvmName("fsapbnfkaqhkiqhb")
    public suspend fun remoteAccess(`value`: NodeGroupRemoteAccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remoteAccess = mapped
    }

    /**
     * @param argument Configuration block with remote access settings. See `remote_access` below for details.
     */
    @JvmName("tetlqfesclfmmhyo")
    public suspend fun remoteAccess(argument: suspend NodeGroupRemoteAccessArgsBuilder.() -> Unit) {
        val toBeMapped = NodeGroupRemoteAccessArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.remoteAccess = mapped
    }

    /**
     * @param value Configuration block with scaling settings. See `scaling_config` below for details.
     */
    @JvmName("xdevpeowfqhiemcb")
    public suspend fun scalingConfig(`value`: NodeGroupScalingConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingConfig = mapped
    }

    /**
     * @param argument Configuration block with scaling settings. See `scaling_config` below for details.
     */
    @JvmName("ghwdaqgwaclchbxi")
    public suspend fun scalingConfig(argument: suspend NodeGroupScalingConfigArgsBuilder.() -> Unit) {
        val toBeMapped = NodeGroupScalingConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scalingConfig = mapped
    }

    /**
     * @param value Identifiers of EC2 Subnets to associate with the EKS Node Group.
     * The following arguments are optional:
     */
    @JvmName("jxenrtympxbrblcq")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifiers of EC2 Subnets to associate with the EKS Node Group.
     * The following arguments are optional:
     */
    @JvmName("pidndeyftbvfhlvl")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umvfnhiwcgpjulpi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("syhgpfudvcqwgfhl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("dxkjjutrfixebkjh")
    public suspend fun taints(`value`: List<NodeGroupTaintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param argument The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("etdjdotkrgnxagpt")
    public suspend fun taints(argument: List<suspend NodeGroupTaintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NodeGroupTaintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("idnxawbepisuapnp")
    public suspend fun taints(vararg argument: suspend NodeGroupTaintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            NodeGroupTaintArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param argument The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("ibsnqfsiblasrgyd")
    public suspend fun taints(argument: suspend NodeGroupTaintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NodeGroupTaintArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.taints = mapped
    }

    /**
     * @param values The Kubernetes taints to be applied to the nodes in the node group. Maximum of 50 taints per node group. See taint below for details.
     */
    @JvmName("prugvoleeurtdwlv")
    public suspend fun taints(vararg values: NodeGroupTaintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taints = mapped
    }

    /**
     * @param value Configuration block with update settings. See `update_config` below for details.
     */
    @JvmName("ytavagsutegelfhc")
    public suspend fun updateConfig(`value`: NodeGroupUpdateConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateConfig = mapped
    }

    /**
     * @param argument Configuration block with update settings. See `update_config` below for details.
     */
    @JvmName("cfmcmjhfxtfakhpm")
    public suspend fun updateConfig(argument: suspend NodeGroupUpdateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = NodeGroupUpdateConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.updateConfig = mapped
    }

    /**
     * @param value Kubernetes version. Defaults to EKS Cluster Kubernetes version. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("uhkdcogecukbupul")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): NodeGroupArgs = NodeGroupArgs(
        amiType = amiType,
        capacityType = capacityType,
        clusterName = clusterName,
        diskSize = diskSize,
        forceUpdateVersion = forceUpdateVersion,
        instanceTypes = instanceTypes,
        labels = labels,
        launchTemplate = launchTemplate,
        nodeGroupName = nodeGroupName,
        nodeGroupNamePrefix = nodeGroupNamePrefix,
        nodeRoleArn = nodeRoleArn,
        releaseVersion = releaseVersion,
        remoteAccess = remoteAccess,
        scalingConfig = scalingConfig,
        subnetIds = subnetIds,
        tags = tags,
        taints = taints,
        updateConfig = updateConfig,
        version = version,
    )
}
