@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterKubernetesNetworkConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ipFamily The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
 * @property serviceIpv4Cidr The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
 * * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
 * * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
 * * Between /24 and /12.
 * @property serviceIpv6Cidr
 */
public data class ClusterKubernetesNetworkConfigArgs(
    public val ipFamily: Output<String>? = null,
    public val serviceIpv4Cidr: Output<String>? = null,
    public val serviceIpv6Cidr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterKubernetesNetworkConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterKubernetesNetworkConfigArgs =
        com.pulumi.aws.eks.inputs.ClusterKubernetesNetworkConfigArgs.builder()
            .ipFamily(ipFamily?.applyValue({ args0 -> args0 }))
            .serviceIpv4Cidr(serviceIpv4Cidr?.applyValue({ args0 -> args0 }))
            .serviceIpv6Cidr(serviceIpv6Cidr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterKubernetesNetworkConfigArgs].
 */
@PulumiTagMarker
public class ClusterKubernetesNetworkConfigArgsBuilder internal constructor() {
    private var ipFamily: Output<String>? = null

    private var serviceIpv4Cidr: Output<String>? = null

    private var serviceIpv6Cidr: Output<String>? = null

    /**
     * @param value The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
     */
    @JvmName("fvgavdpthqfvqtju")
    public suspend fun ipFamily(`value`: Output<String>) {
        this.ipFamily = value
    }

    /**
     * @param value The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
     * * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
     * * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
     * * Between /24 and /12.
     */
    @JvmName("mhvoqukehfiskpqt")
    public suspend fun serviceIpv4Cidr(`value`: Output<String>) {
        this.serviceIpv4Cidr = value
    }

    /**
     * @param value
     */
    @JvmName("sgffwinvwhprevmv")
    public suspend fun serviceIpv6Cidr(`value`: Output<String>) {
        this.serviceIpv6Cidr = value
    }

    /**
     * @param value The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
     */
    @JvmName("oqyeoibojyfkunrb")
    public suspend fun ipFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipFamily = mapped
    }

    /**
     * @param value The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
     * * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
     * * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
     * * Between /24 and /12.
     */
    @JvmName("qctmklwfkdxcyvcd")
    public suspend fun serviceIpv4Cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIpv4Cidr = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjdkgacpnvolvavm")
    public suspend fun serviceIpv6Cidr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceIpv6Cidr = mapped
    }

    internal fun build(): ClusterKubernetesNetworkConfigArgs = ClusterKubernetesNetworkConfigArgs(
        ipFamily = ipFamily,
        serviceIpv4Cidr = serviceIpv4Cidr,
        serviceIpv6Cidr = serviceIpv6Cidr,
    )
}
