@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterOutpostConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property controlPlaneInstanceType The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
 * * 1–20 nodes, then we recommend specifying a large instance type.
 * * 21–100 nodes, then we recommend specifying an xlarge instance type.
 * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
 * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
 * @property controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
 * The `control_plane_placement` configuration block supports the following arguments:
 * @property outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
 */
public data class ClusterOutpostConfigArgs(
    public val controlPlaneInstanceType: Output<String>,
    public val controlPlanePlacement: Output<ClusterOutpostConfigControlPlanePlacementArgs>? = null,
    public val outpostArns: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterOutpostConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterOutpostConfigArgs =
        com.pulumi.aws.eks.inputs.ClusterOutpostConfigArgs.builder()
            .controlPlaneInstanceType(controlPlaneInstanceType.applyValue({ args0 -> args0 }))
            .controlPlanePlacement(
                controlPlanePlacement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outpostArns(outpostArns.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterOutpostConfigArgs].
 */
@PulumiTagMarker
public class ClusterOutpostConfigArgsBuilder internal constructor() {
    private var controlPlaneInstanceType: Output<String>? = null

    private var controlPlanePlacement: Output<ClusterOutpostConfigControlPlanePlacementArgs>? = null

    private var outpostArns: Output<List<String>>? = null

    /**
     * @param value The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
     * * 1–20 nodes, then we recommend specifying a large instance type.
     * * 21–100 nodes, then we recommend specifying an xlarge instance type.
     * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
     * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
     */
    @JvmName("lqgvvvapwnnfwwrl")
    public suspend fun controlPlaneInstanceType(`value`: Output<String>) {
        this.controlPlaneInstanceType = value
    }

    /**
     * @param value An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
     * The `control_plane_placement` configuration block supports the following arguments:
     */
    @JvmName("bkqwnccuxychimca")
    public suspend
    fun controlPlanePlacement(`value`: Output<ClusterOutpostConfigControlPlanePlacementArgs>) {
        this.controlPlanePlacement = value
    }

    /**
     * @param value The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     */
    @JvmName("tclgsciefsyrejhv")
    public suspend fun outpostArns(`value`: Output<List<String>>) {
        this.outpostArns = value
    }

    @JvmName("aehmhvvdptsxyhfa")
    public suspend fun outpostArns(vararg values: Output<String>) {
        this.outpostArns = Output.all(values.asList())
    }

    /**
     * @param values The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     */
    @JvmName("yewfxaqnkmflsfgc")
    public suspend fun outpostArns(values: List<Output<String>>) {
        this.outpostArns = Output.all(values)
    }

    /**
     * @param value The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
     * * 1–20 nodes, then we recommend specifying a large instance type.
     * * 21–100 nodes, then we recommend specifying an xlarge instance type.
     * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
     * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
     */
    @JvmName("bwoeagvliotitkus")
    public suspend fun controlPlaneInstanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlPlaneInstanceType = mapped
    }

    /**
     * @param value An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
     * The `control_plane_placement` configuration block supports the following arguments:
     */
    @JvmName("ffnmghabvjmysgec")
    public suspend
    fun controlPlanePlacement(`value`: ClusterOutpostConfigControlPlanePlacementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlanePlacement = mapped
    }

    /**
     * @param argument An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
     * The `control_plane_placement` configuration block supports the following arguments:
     */
    @JvmName("vcxgwuqglfnhlwme")
    public suspend
    fun controlPlanePlacement(argument: suspend ClusterOutpostConfigControlPlanePlacementArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterOutpostConfigControlPlanePlacementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.controlPlanePlacement = mapped
    }

    /**
     * @param value The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     */
    @JvmName("kvcmicagoibhgcvr")
    public suspend fun outpostArns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outpostArns = mapped
    }

    /**
     * @param values The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
     */
    @JvmName("wivktpmeoyvtnvag")
    public suspend fun outpostArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outpostArns = mapped
    }

    internal fun build(): ClusterOutpostConfigArgs = ClusterOutpostConfigArgs(
        controlPlaneInstanceType = controlPlaneInstanceType ?: throw
            PulumiNullFieldException("controlPlaneInstanceType"),
        controlPlanePlacement = controlPlanePlacement,
        outpostArns = outpostArns ?: throw PulumiNullFieldException("outpostArns"),
    )
}
