@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetClusterAuthPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterAuth.
 * @property name Name of the cluster
 */
public data class GetClusterAuthPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetClusterAuthPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetClusterAuthPlainArgs =
        com.pulumi.aws.eks.inputs.GetClusterAuthPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterAuthPlainArgs].
 */
@PulumiTagMarker
public class GetClusterAuthPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the cluster
     */
    @JvmName("drlvqlwpppspqkob")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetClusterAuthPlainArgs = GetClusterAuthPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
