@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetNodeGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNodeGroup.
 * @property clusterName Name of the cluster.
 * @property nodeGroupName Name of the node group.
 * @property tags Key-value map of resource tags.
 */
public data class GetNodeGroupPlainArgs(
    public val clusterName: String,
    public val nodeGroupName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetNodeGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetNodeGroupPlainArgs =
        com.pulumi.aws.eks.inputs.GetNodeGroupPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .nodeGroupName(nodeGroupName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetNodeGroupPlainArgs].
 */
@PulumiTagMarker
public class GetNodeGroupPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var nodeGroupName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the cluster.
     */
    @JvmName("nmagboknhvecxmsd")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the node group.
     */
    @JvmName("nrddnjyycjxwomkk")
    public suspend fun nodeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.nodeGroupName = mapped
    }

    /**
     * @param value Key-value map of resource tags.
     */
    @JvmName("pgvinsjxagkoifxy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags.
     */
    @JvmName("sdivwygxjurighch")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetNodeGroupPlainArgs = GetNodeGroupPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        nodeGroupName = nodeGroupName ?: throw PulumiNullFieldException("nodeGroupName"),
        tags = tags,
    )
}
