@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property clientId Client ID for the OpenID Connect identity provider.
 * @property groupsClaim The JWT claim that the provider will use to return groups.
 * @property groupsPrefix A prefix that is prepended to group claims e.g., `oidc:`.
 * @property identityProviderConfigName The name of the identity provider config.
 * @property issuerUrl Issuer URL for the OpenID Connect identity provider.
 * @property requiredClaims The key value pairs that describe required claims in the identity token.
 * @property usernameClaim The JWT claim that the provider will use as the username.
 * @property usernamePrefix A prefix that is prepended to username claims.
 */
public data class IdentityProviderConfigOidcArgs(
    public val clientId: Output<String>,
    public val groupsClaim: Output<String>? = null,
    public val groupsPrefix: Output<String>? = null,
    public val identityProviderConfigName: Output<String>,
    public val issuerUrl: Output<String>,
    public val requiredClaims: Output<Map<String, String>>? = null,
    public val usernameClaim: Output<String>? = null,
    public val usernamePrefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs =
        com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .groupsClaim(groupsClaim?.applyValue({ args0 -> args0 }))
            .groupsPrefix(groupsPrefix?.applyValue({ args0 -> args0 }))
            .identityProviderConfigName(identityProviderConfigName.applyValue({ args0 -> args0 }))
            .issuerUrl(issuerUrl.applyValue({ args0 -> args0 }))
            .requiredClaims(
                requiredClaims?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .usernameClaim(usernameClaim?.applyValue({ args0 -> args0 }))
            .usernamePrefix(usernamePrefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityProviderConfigOidcArgs].
 */
@PulumiTagMarker
public class IdentityProviderConfigOidcArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var groupsClaim: Output<String>? = null

    private var groupsPrefix: Output<String>? = null

    private var identityProviderConfigName: Output<String>? = null

    private var issuerUrl: Output<String>? = null

    private var requiredClaims: Output<Map<String, String>>? = null

    private var usernameClaim: Output<String>? = null

    private var usernamePrefix: Output<String>? = null

    /**
     * @param value Client ID for the OpenID Connect identity provider.
     */
    @JvmName("tuykpqsccgyjuihq")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value The JWT claim that the provider will use to return groups.
     */
    @JvmName("ymlvemirhdoyxdso")
    public suspend fun groupsClaim(`value`: Output<String>) {
        this.groupsClaim = value
    }

    /**
     * @param value A prefix that is prepended to group claims e.g., `oidc:`.
     */
    @JvmName("wltdednpfpxqykcy")
    public suspend fun groupsPrefix(`value`: Output<String>) {
        this.groupsPrefix = value
    }

    /**
     * @param value The name of the identity provider config.
     */
    @JvmName("ifeftscsnamdcrgp")
    public suspend fun identityProviderConfigName(`value`: Output<String>) {
        this.identityProviderConfigName = value
    }

    /**
     * @param value Issuer URL for the OpenID Connect identity provider.
     */
    @JvmName("katmealqpqfpgacr")
    public suspend fun issuerUrl(`value`: Output<String>) {
        this.issuerUrl = value
    }

    /**
     * @param value The key value pairs that describe required claims in the identity token.
     */
    @JvmName("cirktgkufmhvbsre")
    public suspend fun requiredClaims(`value`: Output<Map<String, String>>) {
        this.requiredClaims = value
    }

    /**
     * @param value The JWT claim that the provider will use as the username.
     */
    @JvmName("ntckqywpxkmadbcs")
    public suspend fun usernameClaim(`value`: Output<String>) {
        this.usernameClaim = value
    }

    /**
     * @param value A prefix that is prepended to username claims.
     */
    @JvmName("kqeisofskttgyvip")
    public suspend fun usernamePrefix(`value`: Output<String>) {
        this.usernamePrefix = value
    }

    /**
     * @param value Client ID for the OpenID Connect identity provider.
     */
    @JvmName("xucywbsqjewnijfl")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The JWT claim that the provider will use to return groups.
     */
    @JvmName("ojgaomkdlavpybom")
    public suspend fun groupsClaim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupsClaim = mapped
    }

    /**
     * @param value A prefix that is prepended to group claims e.g., `oidc:`.
     */
    @JvmName("edcgwfqxgieklrcj")
    public suspend fun groupsPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupsPrefix = mapped
    }

    /**
     * @param value The name of the identity provider config.
     */
    @JvmName("wwiwkutyngakaxbd")
    public suspend fun identityProviderConfigName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProviderConfigName = mapped
    }

    /**
     * @param value Issuer URL for the OpenID Connect identity provider.
     */
    @JvmName("mdgfxjrdhqicsivb")
    public suspend fun issuerUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuerUrl = mapped
    }

    /**
     * @param value The key value pairs that describe required claims in the identity token.
     */
    @JvmName("eofhbjvtsyidfxkw")
    public suspend fun requiredClaims(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredClaims = mapped
    }

    /**
     * @param values The key value pairs that describe required claims in the identity token.
     */
    @JvmName("lasfcxnaekguipwn")
    public fun requiredClaims(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredClaims = mapped
    }

    /**
     * @param value The JWT claim that the provider will use as the username.
     */
    @JvmName("wyyleddxsotuptua")
    public suspend fun usernameClaim(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernameClaim = mapped
    }

    /**
     * @param value A prefix that is prepended to username claims.
     */
    @JvmName("oseucyicawypxidl")
    public suspend fun usernamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernamePrefix = mapped
    }

    internal fun build(): IdentityProviderConfigOidcArgs = IdentityProviderConfigOidcArgs(
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        groupsClaim = groupsClaim,
        groupsPrefix = groupsPrefix,
        identityProviderConfigName = identityProviderConfigName ?: throw
            PulumiNullFieldException("identityProviderConfigName"),
        issuerUrl = issuerUrl ?: throw PulumiNullFieldException("issuerUrl"),
        requiredClaims = requiredClaims,
        usernameClaim = usernameClaim,
        usernamePrefix = usernamePrefix,
    )
}
