@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property desiredSize Desired number of worker nodes.
 * @property maxSize Maximum number of worker nodes.
 * @property minSize Minimum number of worker nodes.
 */
public data class NodeGroupScalingConfigArgs(
    public val desiredSize: Output<Int>,
    public val maxSize: Output<Int>,
    public val minSize: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs =
        com.pulumi.aws.eks.inputs.NodeGroupScalingConfigArgs.builder()
            .desiredSize(desiredSize.applyValue({ args0 -> args0 }))
            .maxSize(maxSize.applyValue({ args0 -> args0 }))
            .minSize(minSize.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupScalingConfigArgs].
 */
@PulumiTagMarker
public class NodeGroupScalingConfigArgsBuilder internal constructor() {
    private var desiredSize: Output<Int>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    /**
     * @param value Desired number of worker nodes.
     */
    @JvmName("oveturvpoxuwjmps")
    public suspend fun desiredSize(`value`: Output<Int>) {
        this.desiredSize = value
    }

    /**
     * @param value Maximum number of worker nodes.
     */
    @JvmName("tjmbvjlfnnapsyns")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value Minimum number of worker nodes.
     */
    @JvmName("kyhnueshiguxhyip")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value Desired number of worker nodes.
     */
    @JvmName("kcoxrljwvvqmmxrw")
    public suspend fun desiredSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredSize = mapped
    }

    /**
     * @param value Maximum number of worker nodes.
     */
    @JvmName("xhgrmpsvisbdrauf")
    public suspend fun maxSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value Minimum number of worker nodes.
     */
    @JvmName("jvmrcowospbgbrmf")
    public suspend fun minSize(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    internal fun build(): NodeGroupScalingConfigArgs = NodeGroupScalingConfigArgs(
        desiredSize = desiredSize ?: throw PulumiNullFieldException("desiredSize"),
        maxSize = maxSize ?: throw PulumiNullFieldException("maxSize"),
        minSize = minSize ?: throw PulumiNullFieldException("minSize"),
    )
}
