@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.NodeGroupTaintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property effect The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
 * @property key The key of the taint. Maximum length of 63.
 * @property value The value of the taint. Maximum length of 63.
 */
public data class NodeGroupTaintArgs(
    public val effect: Output<String>,
    public val key: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.NodeGroupTaintArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.NodeGroupTaintArgs =
        com.pulumi.aws.eks.inputs.NodeGroupTaintArgs.builder()
            .effect(effect.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupTaintArgs].
 */
@PulumiTagMarker
public class NodeGroupTaintArgsBuilder internal constructor() {
    private var effect: Output<String>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
     */
    @JvmName("eqluwawiqhnexugf")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value The key of the taint. Maximum length of 63.
     */
    @JvmName("blgoewepmeifgtlb")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the taint. Maximum length of 63.
     */
    @JvmName("lkbyuptxeufuobwy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
     */
    @JvmName("kwwldytgceaohmtx")
    public suspend fun effect(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value The key of the taint. Maximum length of 63.
     */
    @JvmName("hvwueayfpwqeigoo")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the taint. Maximum length of 63.
     */
    @JvmName("mluamyfaeryxdqim")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NodeGroupTaintArgs = NodeGroupTaintArgs(
        effect = effect ?: throw PulumiNullFieldException("effect"),
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value`,
    )
}
