@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyArn ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
 */
public data class ClusterEncryptionConfigProvider(
    public val keyArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterEncryptionConfigProvider):
            ClusterEncryptionConfigProvider = ClusterEncryptionConfigProvider(
            keyArn = javaType.keyArn(),
        )
    }
}
