@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property issuer Issuer URL for the OpenID Connect identity provider.
 */
public data class ClusterIdentityOidc(
    public val issuer: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterIdentityOidc):
            ClusterIdentityOidc = ClusterIdentityOidc(
            issuer = javaType.issuer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
