@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipFamily The IP family used to assign Kubernetes pod and service addresses. Valid values are `ipv4` (default) and `ipv6`. You can only specify an IP family when you create a cluster, changing this value will force a new cluster to be created.
 * @property serviceIpv4Cidr The CIDR block to assign Kubernetes pod and service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. You can only specify a custom CIDR block when you create a cluster, changing this value will force a new cluster to be created. The block must meet the following requirements:
 * * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12, or 192.168.0.0/16.
 * * Doesn't overlap with any CIDR block assigned to the VPC that you selected for VPC.
 * * Between /24 and /12.
 * @property serviceIpv6Cidr
 */
public data class ClusterKubernetesNetworkConfig(
    public val ipFamily: String? = null,
    public val serviceIpv4Cidr: String? = null,
    public val serviceIpv6Cidr: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterKubernetesNetworkConfig):
            ClusterKubernetesNetworkConfig = ClusterKubernetesNetworkConfig(
            ipFamily = javaType.ipFamily().map({ args0 -> args0 }).orElse(null),
            serviceIpv4Cidr = javaType.serviceIpv4Cidr().map({ args0 -> args0 }).orElse(null),
            serviceIpv6Cidr = javaType.serviceIpv6Cidr().map({ args0 -> args0 }).orElse(null),
        )
    }
}
