@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property controlPlaneInstanceType The Amazon EC2 instance type that you want to use for your local Amazon EKS cluster on Outposts. The instance type that you specify is used for all Kubernetes control plane instances. The instance type can't be changed after cluster creation. Choose an instance type based on the number of nodes that your cluster will have. If your cluster will have:
 * * 1–20 nodes, then we recommend specifying a large instance type.
 * * 21–100 nodes, then we recommend specifying an xlarge instance type.
 * * 101–250 nodes, then we recommend specifying a 2xlarge instance type.
 * For a list of the available Amazon EC2 instance types, see Compute and storage in AWS Outposts rack features  The control plane is not automatically scaled by Amazon EKS.
 * @property controlPlanePlacement An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
 * The `control_plane_placement` configuration block supports the following arguments:
 * @property outpostArns The ARN of the Outpost that you want to use for your local Amazon EKS cluster on Outposts. This argument is a list of arns, but only a single Outpost ARN is supported currently.
 */
public data class ClusterOutpostConfig(
    public val controlPlaneInstanceType: String,
    public val controlPlanePlacement: ClusterOutpostConfigControlPlanePlacement? = null,
    public val outpostArns: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterOutpostConfig):
            ClusterOutpostConfig = ClusterOutpostConfig(
            controlPlaneInstanceType = javaType.controlPlaneInstanceType(),
            controlPlanePlacement = javaType.controlPlanePlacement().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.eks.kotlin.outputs.ClusterOutpostConfigControlPlanePlacement.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outpostArns = javaType.outpostArns().map({ args0 -> args0 }),
        )
    }
}
