@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterSecurityGroupId Cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
 * @property endpointPrivateAccess Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
 * @property endpointPublicAccess Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
 * @property publicAccessCidrs List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
 * @property securityGroupIds List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
 * @property subnetIds List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
 * @property vpcId ID of the VPC associated with your cluster.
 */
public data class ClusterVpcConfig(
    public val clusterSecurityGroupId: String? = null,
    public val endpointPrivateAccess: Boolean? = null,
    public val endpointPublicAccess: Boolean? = null,
    public val publicAccessCidrs: List<String>? = null,
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterVpcConfig): ClusterVpcConfig =
            ClusterVpcConfig(
                clusterSecurityGroupId = javaType.clusterSecurityGroupId().map({ args0 -> args0 }).orElse(null),
                endpointPrivateAccess = javaType.endpointPrivateAccess().map({ args0 -> args0 }).orElse(null),
                endpointPublicAccess = javaType.endpointPublicAccess().map({ args0 -> args0 }).orElse(null),
                publicAccessCidrs = javaType.publicAccessCidrs().map({ args0 -> args0 }),
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
                vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
