@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property oidcs Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster.
 */
public data class GetClusterIdentity(
    public val oidcs: List<GetClusterIdentityOidc>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterIdentity): GetClusterIdentity =
            GetClusterIdentity(
                oidcs = javaType.oidcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterIdentityOidc.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
