@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clusterSecurityGroupId The cluster security group that was created by Amazon EKS for the cluster.
 * @property endpointPrivateAccess Indicates whether or not the Amazon EKS private API server endpoint is enabled.
 * @property endpointPublicAccess Indicates whether or not the Amazon EKS public API server endpoint is enabled.
 * @property publicAccessCidrs List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint.
 * @property securityGroupIds List of security group IDs
 * @property subnetIds List of subnet IDs
 * @property vpcId The VPC associated with your cluster.
 */
public data class GetClusterVpcConfig(
    public val clusterSecurityGroupId: String,
    public val endpointPrivateAccess: Boolean,
    public val endpointPublicAccess: Boolean,
    public val publicAccessCidrs: List<String>,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterVpcConfig):
            GetClusterVpcConfig = GetClusterVpcConfig(
            clusterSecurityGroupId = javaType.clusterSecurityGroupId(),
            endpointPrivateAccess = javaType.endpointPrivateAccess(),
            endpointPublicAccess = javaType.endpointPublicAccess(),
            publicAccessCidrs = javaType.publicAccessCidrs().map({ args0 -> args0 }),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
