@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getClusters.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of EKS clusters names
 */
public data class GetClustersResult(
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClustersResult): GetClustersResult =
            GetClustersResult(
                id = javaType.id(),
                names = javaType.names().map({ args0 -> args0 }),
            )
    }
}
