@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ec2SshKey EC2 Key Pair name that provides access for SSH communication with the worker nodes in the EKS Node Group.
 * @property sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes.
 */
public data class GetNodeGroupRemoteAccess(
    public val ec2SshKey: String,
    public val sourceSecurityGroupIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetNodeGroupRemoteAccess):
            GetNodeGroupRemoteAccess = GetNodeGroupRemoteAccess(
            ec2SshKey = javaType.ec2SshKey(),
            sourceSecurityGroupIds = javaType.sourceSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
