@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNodeGroups.
 * @property clusterName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of all node group names in an EKS Cluster.
 */
public data class GetNodeGroupsResult(
    public val clusterName: String,
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetNodeGroupsResult):
            GetNodeGroupsResult = GetNodeGroupsResult(
            clusterName = javaType.clusterName(),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
