@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property clientId Client ID for the OpenID Connect identity provider.
 * @property groupsClaim The JWT claim that the provider will use to return groups.
 * @property groupsPrefix A prefix that is prepended to group claims e.g., `oidc:`.
 * @property identityProviderConfigName The name of the identity provider config.
 * @property issuerUrl Issuer URL for the OpenID Connect identity provider.
 * @property requiredClaims The key value pairs that describe required claims in the identity token.
 * @property usernameClaim The JWT claim that the provider will use as the username.
 * @property usernamePrefix A prefix that is prepended to username claims.
 */
public data class IdentityProviderConfigOidc(
    public val clientId: String,
    public val groupsClaim: String? = null,
    public val groupsPrefix: String? = null,
    public val identityProviderConfigName: String,
    public val issuerUrl: String,
    public val requiredClaims: Map<String, String>? = null,
    public val usernameClaim: String? = null,
    public val usernamePrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.IdentityProviderConfigOidc):
            IdentityProviderConfigOidc = IdentityProviderConfigOidc(
            clientId = javaType.clientId(),
            groupsClaim = javaType.groupsClaim().map({ args0 -> args0 }).orElse(null),
            groupsPrefix = javaType.groupsPrefix().map({ args0 -> args0 }).orElse(null),
            identityProviderConfigName = javaType.identityProviderConfigName(),
            issuerUrl = javaType.issuerUrl(),
            requiredClaims = javaType.requiredClaims().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            usernameClaim = javaType.usernameClaim().map({ args0 -> args0 }).orElse(null),
            usernamePrefix = javaType.usernamePrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
