@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id Identifier of the EC2 Launch Template. Conflicts with `name`.
 * @property name Name of the EC2 Launch Template. Conflicts with `id`.
 * @property version EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource or data source is recommended for this argument.
 */
public data class NodeGroupLaunchTemplate(
    public val id: String? = null,
    public val name: String? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.NodeGroupLaunchTemplate):
            NodeGroupLaunchTemplate = NodeGroupLaunchTemplate(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
