@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property desiredSize Desired number of worker nodes.
 * @property maxSize Maximum number of worker nodes.
 * @property minSize Minimum number of worker nodes.
 */
public data class NodeGroupScalingConfig(
    public val desiredSize: Int,
    public val maxSize: Int,
    public val minSize: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.NodeGroupScalingConfig):
            NodeGroupScalingConfig = NodeGroupScalingConfig(
            desiredSize = javaType.desiredSize(),
            maxSize = javaType.maxSize(),
            minSize = javaType.minSize(),
        )
    }
}
