@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property effect The effect of the taint. Valid values: `NO_SCHEDULE`, `NO_EXECUTE`, `PREFER_NO_SCHEDULE`.
 * @property key The key of the taint. Maximum length of 63.
 * @property value The value of the taint. Maximum length of 63.
 */
public data class NodeGroupTaint(
    public val effect: String,
    public val key: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.NodeGroupTaint): NodeGroupTaint =
            NodeGroupTaint(
                effect = javaType.effect(),
                key = javaType.key(),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
