@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxUnavailable Desired max number of unavailable worker nodes during node group update.
 * @property maxUnavailablePercentage Desired max percentage of unavailable worker nodes during node group update.
 */
public data class NodeGroupUpdateConfig(
    public val maxUnavailable: Int? = null,
    public val maxUnavailablePercentage: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.NodeGroupUpdateConfig):
            NodeGroupUpdateConfig = NodeGroupUpdateConfig(
            maxUnavailable = javaType.maxUnavailable().map({ args0 -> args0 }).orElse(null),
            maxUnavailablePercentage = javaType.maxUnavailablePercentage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
