@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.kotlin.outputs.GlobalReplicationGroupGlobalNodeGroup
import com.pulumi.aws.elasticache.kotlin.outputs.GlobalReplicationGroupGlobalNodeGroup.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GlobalReplicationGroup].
 */
@PulumiTagMarker
public class GlobalReplicationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalReplicationGroupArgs = GlobalReplicationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalReplicationGroupArgsBuilder.() -> Unit) {
        val builder = GlobalReplicationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): GlobalReplicationGroup {
        val builtJavaResource =
            com.pulumi.aws.elasticache.GlobalReplicationGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return GlobalReplicationGroup(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache Global Replication Group resource, which manages replication between two or more Replication Groups in different regions. For more information, see the [ElastiCache User Guide](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
 * ## Example Usage
 * ### Global replication group with one secondary replication group
 * The global replication group depends on the primary group existing. Secondary replication groups depend on the global replication group. the provider dependency management will handle this transparently using resource value references.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup("primary", ReplicationGroupArgs.builder()
 *             .description("primary replication group")
 *             .engine("redis")
 *             .engineVersion("5.0.6")
 *             .nodeType("cache.m5.large")
 *             .numCacheClusters(1)
 *             .build());
 *         var example = new GlobalReplicationGroup("example", GlobalReplicationGroupArgs.builder()
 *             .globalReplicationGroupIdSuffix("example")
 *             .primaryReplicationGroupId(primary.id())
 *             .build());
 *         var secondary = new ReplicationGroup("secondary", ReplicationGroupArgs.builder()
 *             .description("secondary replication group")
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *     }
 * }
 * ```
 * ### Managing Redis Engine Versions
 * The initial Redis version is determined by the version set on the primary replication group.
 * However, once it is part of a Global Replication Group,
 * the Global Replication Group manages the version of all member replication groups.
 * The member replication groups must have `lifecycle.ignore_changes[engine_version]` set,
 * or the provider will always return a diff.
 * In this example,
 * the primary replication group will be created with Redis 6.0,
 * and then upgraded to Redis 6.2 once added to the Global Replication Group.
 * The secondary replication group will be created with Redis 6.2.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup("primary", ReplicationGroupArgs.builder()
 *             .description("primary replication group")
 *             .engine("redis")
 *             .engineVersion("6.0")
 *             .nodeType("cache.m5.large")
 *             .numCacheClusters(1)
 *             .build());
 *         var example = new GlobalReplicationGroup("example", GlobalReplicationGroupArgs.builder()
 *             .globalReplicationGroupIdSuffix("example")
 *             .primaryReplicationGroupId(primary.id())
 *             .engineVersion("6.2")
 *             .build());
 *         var secondary = new ReplicationGroup("secondary", ReplicationGroupArgs.builder()
 *             .description("secondary replication group")
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache Global Replication Groups using the `global_replication_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/globalReplicationGroup:GlobalReplicationGroup my_global_replication_group okuqm-global-replication-group-1
 * ```
 *
 */
public class GlobalReplicationGroup internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.GlobalReplicationGroup,
) : KotlinCustomResource(javaResource, GlobalReplicationGroupMapper) {
    /**
     * The ARN of the ElastiCache Global Replication Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A flag that indicate whether the encryption at rest is enabled.
     */
    public val atRestEncryptionEnabled: Output<Boolean>
        get() = javaResource.atRestEncryptionEnabled().applyValue({ args0 -> args0 })

    /**
     * A flag that indicate whether AuthToken (password) is enabled.
     */
    public val authTokenEnabled: Output<Boolean>
        get() = javaResource.authTokenEnabled().applyValue({ args0 -> args0 })

    /**
     * Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
     * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
     */
    public val automaticFailoverEnabled: Output<Boolean>
        get() = javaResource.automaticFailoverEnabled().applyValue({ args0 -> args0 })

    /**
     * The instance class used.
     * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
     * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
     * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
     */
    public val cacheNodeType: Output<String>
        get() = javaResource.cacheNodeType().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the Global Datastore is cluster enabled.
     */
    public val clusterEnabled: Output<Boolean>
        get() = javaResource.clusterEnabled().applyValue({ args0 -> args0 })

    /**
     * The name of the cache engine to be used for the clusters in this global replication group.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Redis version to use for the Global Replication Group.
     * When creating, by default the Global Replication Group inherits the version of the primary replication group.
     * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
     * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
     * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * The full version number of the cache engine running on the members of this global replication group.
     */
    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * Set of node groups (shards) on the global replication group.
     * Has the values:
     */
    public val globalNodeGroups: Output<List<GlobalReplicationGroupGlobalNodeGroup>>
        get() = javaResource.globalNodeGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * A user-created description for the global replication group.
     */
    public val globalReplicationGroupDescription: Output<String>?
        get() = javaResource.globalReplicationGroupDescription().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * The full ID of the global replication group.
     */
    public val globalReplicationGroupId: Output<String>
        get() = javaResource.globalReplicationGroupId().applyValue({ args0 -> args0 })

    /**
     * The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
     */
    public val globalReplicationGroupIdSuffix: Output<String>
        get() = javaResource.globalReplicationGroupIdSuffix().applyValue({ args0 -> args0 })

    /**
     * The number of node groups (shards) on the global replication group.
     */
    public val numNodeGroups: Output<Int>
        get() = javaResource.numNodeGroups().applyValue({ args0 -> args0 })

    /**
     * An ElastiCache Parameter Group to use for the Global Replication Group.
     * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
     * Specifying without a major version upgrade will fail.
     * Note that ElastiCache creates a copy of this parameter group for each member replication group.
     */
    public val parameterGroupName: Output<String>?
        get() = javaResource.parameterGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
     */
    public val primaryReplicationGroupId: Output<String>
        get() = javaResource.primaryReplicationGroupId().applyValue({ args0 -> args0 })

    /**
     * A flag that indicates whether the encryption in transit is enabled.
     */
    public val transitEncryptionEnabled: Output<Boolean>
        get() = javaResource.transitEncryptionEnabled().applyValue({ args0 -> args0 })
}

public object GlobalReplicationGroupMapper : ResourceMapper<GlobalReplicationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.GlobalReplicationGroup::class == javaResource::class

    override fun map(javaResource: Resource): GlobalReplicationGroup =
        GlobalReplicationGroup(javaResource as com.pulumi.aws.elasticache.GlobalReplicationGroup)
}

/**
 * @see [GlobalReplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalReplicationGroup].
 */
public suspend fun globalReplicationGroup(
    name: String,
    block: suspend GlobalReplicationGroupResourceBuilder.() -> Unit,
): GlobalReplicationGroup {
    val builder = GlobalReplicationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalReplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalReplicationGroup(name: String): GlobalReplicationGroup {
    val builder = GlobalReplicationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
