@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache Global Replication Group resource, which manages replication between two or more Replication Groups in different regions. For more information, see the [ElastiCache User Guide](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html).
 * ## Example Usage
 * ### Global replication group with one secondary replication group
 * The global replication group depends on the primary group existing. Secondary replication groups depend on the global replication group. the provider dependency management will handle this transparently using resource value references.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup("primary", ReplicationGroupArgs.builder()
 *             .description("primary replication group")
 *             .engine("redis")
 *             .engineVersion("5.0.6")
 *             .nodeType("cache.m5.large")
 *             .numCacheClusters(1)
 *             .build());
 *         var example = new GlobalReplicationGroup("example", GlobalReplicationGroupArgs.builder()
 *             .globalReplicationGroupIdSuffix("example")
 *             .primaryReplicationGroupId(primary.id())
 *             .build());
 *         var secondary = new ReplicationGroup("secondary", ReplicationGroupArgs.builder()
 *             .description("secondary replication group")
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *     }
 * }
 * ```
 * ### Managing Redis Engine Versions
 * The initial Redis version is determined by the version set on the primary replication group.
 * However, once it is part of a Global Replication Group,
 * the Global Replication Group manages the version of all member replication groups.
 * The member replication groups must have `lifecycle.ignore_changes[engine_version]` set,
 * or the provider will always return a diff.
 * In this example,
 * the primary replication group will be created with Redis 6.0,
 * and then upgraded to Redis 6.2 once added to the Global Replication Group.
 * The secondary replication group will be created with Redis 6.2.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup("primary", ReplicationGroupArgs.builder()
 *             .description("primary replication group")
 *             .engine("redis")
 *             .engineVersion("6.0")
 *             .nodeType("cache.m5.large")
 *             .numCacheClusters(1)
 *             .build());
 *         var example = new GlobalReplicationGroup("example", GlobalReplicationGroupArgs.builder()
 *             .globalReplicationGroupIdSuffix("example")
 *             .primaryReplicationGroupId(primary.id())
 *             .engineVersion("6.2")
 *             .build());
 *         var secondary = new ReplicationGroup("secondary", ReplicationGroupArgs.builder()
 *             .description("secondary replication group")
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache Global Replication Groups using the `global_replication_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/globalReplicationGroup:GlobalReplicationGroup my_global_replication_group okuqm-global-replication-group-1
 * ```
 * @property automaticFailoverEnabled Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
 * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
 * @property cacheNodeType The instance class used.
 * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
 * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
 * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
 * @property engineVersion Redis version to use for the Global Replication Group.
 * When creating, by default the Global Replication Group inherits the version of the primary replication group.
 * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
 * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
 * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
 * When the version is 6, the major and minor version can be set, e.g., `6.2`,
 * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
 * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
 * @property globalReplicationGroupDescription A user-created description for the global replication group.
 * @property globalReplicationGroupIdSuffix The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
 * @property numNodeGroups The number of node groups (shards) on the global replication group.
 * @property parameterGroupName An ElastiCache Parameter Group to use for the Global Replication Group.
 * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
 * Specifying without a major version upgrade will fail.
 * Note that ElastiCache creates a copy of this parameter group for each member replication group.
 * @property primaryReplicationGroupId The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
 */
public data class GlobalReplicationGroupArgs(
    public val automaticFailoverEnabled: Output<Boolean>? = null,
    public val cacheNodeType: Output<String>? = null,
    public val engineVersion: Output<String>? = null,
    public val globalReplicationGroupDescription: Output<String>? = null,
    public val globalReplicationGroupIdSuffix: Output<String>? = null,
    public val numNodeGroups: Output<Int>? = null,
    public val parameterGroupName: Output<String>? = null,
    public val primaryReplicationGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.GlobalReplicationGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.GlobalReplicationGroupArgs =
        com.pulumi.aws.elasticache.GlobalReplicationGroupArgs.builder()
            .automaticFailoverEnabled(automaticFailoverEnabled?.applyValue({ args0 -> args0 }))
            .cacheNodeType(cacheNodeType?.applyValue({ args0 -> args0 }))
            .engineVersion(engineVersion?.applyValue({ args0 -> args0 }))
            .globalReplicationGroupDescription(
                globalReplicationGroupDescription?.applyValue({ args0 ->
                    args0
                }),
            )
            .globalReplicationGroupIdSuffix(globalReplicationGroupIdSuffix?.applyValue({ args0 -> args0 }))
            .numNodeGroups(numNodeGroups?.applyValue({ args0 -> args0 }))
            .parameterGroupName(parameterGroupName?.applyValue({ args0 -> args0 }))
            .primaryReplicationGroupId(primaryReplicationGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalReplicationGroupArgs].
 */
@PulumiTagMarker
public class GlobalReplicationGroupArgsBuilder internal constructor() {
    private var automaticFailoverEnabled: Output<Boolean>? = null

    private var cacheNodeType: Output<String>? = null

    private var engineVersion: Output<String>? = null

    private var globalReplicationGroupDescription: Output<String>? = null

    private var globalReplicationGroupIdSuffix: Output<String>? = null

    private var numNodeGroups: Output<Int>? = null

    private var parameterGroupName: Output<String>? = null

    private var primaryReplicationGroupId: Output<String>? = null

    /**
     * @param value Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
     * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
     */
    @JvmName("kkbthfvsejkpexpg")
    public suspend fun automaticFailoverEnabled(`value`: Output<Boolean>) {
        this.automaticFailoverEnabled = value
    }

    /**
     * @param value The instance class used.
     * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
     * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
     * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
     */
    @JvmName("uqrhuknfopmsjilf")
    public suspend fun cacheNodeType(`value`: Output<String>) {
        this.cacheNodeType = value
    }

    /**
     * @param value Redis version to use for the Global Replication Group.
     * When creating, by default the Global Replication Group inherits the version of the primary replication group.
     * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
     * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
     * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     */
    @JvmName("qudssrlvcnyqlbok")
    public suspend fun engineVersion(`value`: Output<String>) {
        this.engineVersion = value
    }

    /**
     * @param value A user-created description for the global replication group.
     */
    @JvmName("oqugkfjfsesvagfl")
    public suspend fun globalReplicationGroupDescription(`value`: Output<String>) {
        this.globalReplicationGroupDescription = value
    }

    /**
     * @param value The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
     */
    @JvmName("ocadhoqsupxwrlwr")
    public suspend fun globalReplicationGroupIdSuffix(`value`: Output<String>) {
        this.globalReplicationGroupIdSuffix = value
    }

    /**
     * @param value The number of node groups (shards) on the global replication group.
     */
    @JvmName("vsxqyrwsbhaojlld")
    public suspend fun numNodeGroups(`value`: Output<Int>) {
        this.numNodeGroups = value
    }

    /**
     * @param value An ElastiCache Parameter Group to use for the Global Replication Group.
     * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
     * Specifying without a major version upgrade will fail.
     * Note that ElastiCache creates a copy of this parameter group for each member replication group.
     */
    @JvmName("rjhtudxanoqcqsfu")
    public suspend fun parameterGroupName(`value`: Output<String>) {
        this.parameterGroupName = value
    }

    /**
     * @param value The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
     */
    @JvmName("saffskklykfbseuy")
    public suspend fun primaryReplicationGroupId(`value`: Output<String>) {
        this.primaryReplicationGroupId = value
    }

    /**
     * @param value Specifies whether read-only replicas will be automatically promoted to read/write primary if the existing primary fails.
     * When creating, by default the Global Replication Group inherits the automatic failover setting of the primary replication group.
     */
    @JvmName("ejcuporxkeyrmwjx")
    public suspend fun automaticFailoverEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticFailoverEnabled = mapped
    }

    /**
     * @param value The instance class used.
     * See AWS documentation for information on [supported node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html)
     * and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html).
     * When creating, by default the Global Replication Group inherits the node type of the primary replication group.
     */
    @JvmName("kgmaqohbwamfgmdu")
    public suspend fun cacheNodeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheNodeType = mapped
    }

    /**
     * @param value Redis version to use for the Global Replication Group.
     * When creating, by default the Global Replication Group inherits the version of the primary replication group.
     * If a version is specified, the Global Replication Group and all member replication groups will be upgraded to this version.
     * Cannot be downgraded without replacing the Global Replication Group and all member replication groups.
     * When the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * When the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     */
    @JvmName("mmllcvcihclktubq")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineVersion = mapped
    }

    /**
     * @param value A user-created description for the global replication group.
     */
    @JvmName("cijubmrpgqqjeucn")
    public suspend fun globalReplicationGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalReplicationGroupDescription = mapped
    }

    /**
     * @param value The suffix name of a Global Datastore. If `global_replication_group_id_suffix` is changed, creates a new resource.
     */
    @JvmName("hcnheiphriexipjl")
    public suspend fun globalReplicationGroupIdSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalReplicationGroupIdSuffix = mapped
    }

    /**
     * @param value The number of node groups (shards) on the global replication group.
     */
    @JvmName("hprfjpykjlvwxfes")
    public suspend fun numNodeGroups(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.numNodeGroups = mapped
    }

    /**
     * @param value An ElastiCache Parameter Group to use for the Global Replication Group.
     * Required when upgrading a major engine version, but will be ignored if left configured after the upgrade is complete.
     * Specifying without a major version upgrade will fail.
     * Note that ElastiCache creates a copy of this parameter group for each member replication group.
     */
    @JvmName("xawdxsbfantxtrrn")
    public suspend fun parameterGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterGroupName = mapped
    }

    /**
     * @param value The ID of the primary cluster that accepts writes and will replicate updates to the secondary cluster. If `primary_replication_group_id` is changed, creates a new resource.
     */
    @JvmName("caaclujjcptkxyjk")
    public suspend fun primaryReplicationGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryReplicationGroupId = mapped
    }

    internal fun build(): GlobalReplicationGroupArgs = GlobalReplicationGroupArgs(
        automaticFailoverEnabled = automaticFailoverEnabled,
        cacheNodeType = cacheNodeType,
        engineVersion = engineVersion,
        globalReplicationGroupDescription = globalReplicationGroupDescription,
        globalReplicationGroupIdSuffix = globalReplicationGroupIdSuffix,
        numNodeGroups = numNodeGroups,
        parameterGroupName = parameterGroupName,
        primaryReplicationGroupId = primaryReplicationGroupId,
    )
}
