@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.kotlin.outputs.ParameterGroupParameter
import com.pulumi.aws.elasticache.kotlin.outputs.ParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ParameterGroup].
 */
@PulumiTagMarker
public class ParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ParameterGroupArgs = ParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ParameterGroupArgsBuilder.() -> Unit) {
        val builder = ParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ParameterGroup {
        val builtJavaResource = com.pulumi.aws.elasticache.ParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ParameterGroup(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache parameter group resource.
 * > **NOTE:** Attempting to remove the `reserved-memory` parameter when `family` is set to `redis2.6` or `redis2.8` may show a perpetual difference in this provider due to an ElastiCache API limitation. Leave that parameter configured with any value to workaround the issue.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ParameterGroup;
 * import com.pulumi.aws.elasticache.ParameterGroupArgs;
 * import com.pulumi.aws.elasticache.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ParameterGroup("default", ParameterGroupArgs.builder()
 *             .family("redis2.8")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("activerehashing")
 *                     .value("yes")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("min-slaves-to-write")
 *                     .value("2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache Parameter Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/parameterGroup:ParameterGroup default redis-params
 * ```
 *
 */
public class ParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.ParameterGroup,
) : KotlinCustomResource(javaResource, ParameterGroupMapper) {
    /**
     * The AWS ARN associated with the parameter group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the ElastiCache parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The family of the ElastiCache parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the ElastiCache parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A list of ElastiCache parameters to apply.
     */
    public val parameters: Output<List<ParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ParameterGroupMapper : ResourceMapper<ParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.ParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ParameterGroup = ParameterGroup(
        javaResource as
            com.pulumi.aws.elasticache.ParameterGroup,
    )
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ParameterGroup].
 */
public suspend fun parameterGroup(
    name: String,
    block: suspend ParameterGroupResourceBuilder.() -> Unit,
): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun parameterGroup(name: String): ParameterGroup {
    val builder = ParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
