@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.kotlin.outputs.ReplicationGroupLogDeliveryConfiguration
import com.pulumi.aws.elasticache.kotlin.outputs.ReplicationGroupLogDeliveryConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ReplicationGroup].
 */
@PulumiTagMarker
public class ReplicationGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationGroupArgs = ReplicationGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationGroupArgsBuilder.() -> Unit) {
        val builder = ReplicationGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ReplicationGroup {
        val builtJavaResource = com.pulumi.aws.elasticache.ReplicationGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReplicationGroup(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache Replication Group resource.
 * For working with a [Memcached cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/WhatIs.html) or a
 * [single-node Redis instance (Cluster Mode Disabled)](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/WhatIs.html),
 * see the `aws.elasticache.Cluster` resource.
 * > **Note:** When you change an attribute, such as `engine_version`, by
 * default the ElastiCache API applies it in the next maintenance window. Because
 * of this, this provider may report a difference in its planning phase because the
 * actual modification has not yet taken place. You can use the
 * `apply_immediately` flag to instruct the service to apply the change
 * immediately. Using `apply_immediately` can result in a brief downtime as
 * servers reboots.
 * See the AWS Documentation on
 * [Modifying an ElastiCache Cache Cluster](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Modify.html)
 * for more information.
 * > **Note:** Any attribute changes that re-create the resource will be applied immediately, regardless of the value of `apply_immediately`.
 * > **Note:** Be aware of the terminology collision around "cluster" for `aws.elasticache.ReplicationGroup`. For example, it is possible to create a ["Cluster Mode Disabled [Redis] Cluster"](https://docs&#46;aws&#46;amazon&#46;com/AmazonElastiCache/latest/red-ug/Clusters&#46;Create&#46;CON&#46;Redis&#46;html)&#46; With "Cluster Mode Enabled", the data will be stored in shards (called "node groups")&#46; See [Redis Cluster Configuration](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/cluster-create-determine-requirements.html#redis-cluster-configuration) for a diagram of the differences. To enable cluster mode, use a parameter group that has cluster mode enabled. The default parameter groups provided by AWS end with ".cluster.on", for example `default.redis6.x.cluster.on`.
 * ## Example Usage
 * ### Redis Cluster Mode Disabled
 * To create a single shard primary with single read replica:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReplicationGroup("example", ReplicationGroupArgs.builder()
 *             .automaticFailoverEnabled(true)
 *             .description("example description")
 *             .nodeType("cache.m4.large")
 *             .numCacheClusters(2)
 *             .parameterGroupName("default.redis3.2")
 *             .port(6379)
 *             .preferredCacheClusterAzs(
 *                 "us-west-2a",
 *                 "us-west-2b")
 *             .build());
 *     }
 * }
 * ```
 * ### Redis Cluster Mode Enabled
 * To create two shards with a primary and a single read replica each:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var baz = new ReplicationGroup("baz", ReplicationGroupArgs.builder()
 *             .automaticFailoverEnabled(true)
 *             .description("example description")
 *             .nodeType("cache.t2.small")
 *             .numNodeGroups(2)
 *             .parameterGroupName("default.redis3.2.cluster.on")
 *             .port(6379)
 *             .replicasPerNodeGroup(1)
 *             .build());
 *     }
 * }
 * ```
 * ### Redis Log Delivery configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.inputs.ReplicationGroupLogDeliveryConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ReplicationGroup("test", ReplicationGroupArgs.builder()
 *             .description("test description")
 *             .nodeType("cache.t3.small")
 *             .port(6379)
 *             .applyImmediately(true)
 *             .autoMinorVersionUpgrade(false)
 *             .maintenanceWindow("tue:06:30-tue:07:30")
 *             .snapshotWindow("01:00-02:00")
 *             .logDeliveryConfigurations(
 *                 ReplicationGroupLogDeliveryConfigurationArgs.builder()
 *                     .destination(aws_cloudwatch_log_group.example().name())
 *                     .destinationType("cloudwatch-logs")
 *                     .logFormat("text")
 *                     .logType("slow-log")
 *                     .build(),
 *                 ReplicationGroupLogDeliveryConfigurationArgs.builder()
 *                     .destination(aws_kinesis_firehose_delivery_stream.example().name())
 *                     .destinationType("kinesis-firehose")
 *                     .logFormat("json")
 *                     .logType("engine-log")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Creating a secondary replication group for a global replication group
 * A Global Replication Group can have one one two secondary Replication Groups in different regions. These are added to an existing Global Replication Group.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroup;
 * import com.pulumi.aws.elasticache.GlobalReplicationGroupArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new ReplicationGroup("primary", ReplicationGroupArgs.builder()
 *             .description("primary replication group")
 *             .engine("redis")
 *             .engineVersion("5.0.6")
 *             .nodeType("cache.m5.large")
 *             .numCacheClusters(1)
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *         var example = new GlobalReplicationGroup("example", GlobalReplicationGroupArgs.builder()
 *             .globalReplicationGroupIdSuffix("example")
 *             .primaryReplicationGroupId(primary.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider(aws.other_region())
 *                 .build());
 *         var secondary = new ReplicationGroup("secondary", ReplicationGroupArgs.builder()
 *             .description("secondary replication group")
 *             .globalReplicationGroupId(example.globalReplicationGroupId())
 *             .numCacheClusters(1)
 *             .build());
 *     }
 * }
 * ```
 * ### Redis AUTH and In-Transit Encryption Enabled
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ReplicationGroup;
 * import com.pulumi.aws.elasticache.ReplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ReplicationGroup("example", ReplicationGroupArgs.builder()
 *             .description("example with authentication")
 *             .nodeType("cache.t2.micro")
 *             .numCacheClusters(1)
 *             .port(6379)
 *             .subnetGroupName(aws_elasticache_subnet_group.example().name())
 *             .securityGroupIds(aws_security_group.example().id())
 *             .parameterGroupName("default.redis5.0")
 *             .engineVersion("5.0.6")
 *             .transitEncryptionEnabled(true)
 *             .authToken("abcdefgh1234567890")
 *             .authTokenUpdateStrategy("ROTATE")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache Replication Groups using the `replication_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/replicationGroup:ReplicationGroup my_replication_group replication-group-1
 * ```
 *
 */
public class ReplicationGroup internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.ReplicationGroup,
) : KotlinCustomResource(javaResource, ReplicationGroupMapper) {
    /**
     * Specifies whether any modifications are applied immediately, or during the next maintenance window. Default is `false`.
     */
    public val applyImmediately: Output<Boolean>
        get() = javaResource.applyImmediately().applyValue({ args0 -> args0 })

    /**
     * ARN of the created ElastiCache Replication Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether to enable encryption at rest.
     */
    public val atRestEncryptionEnabled: Output<Boolean>
        get() = javaResource.atRestEncryptionEnabled().applyValue({ args0 -> args0 })

    /**
     * Password used to access a password protected server. Can be specified only if `transit_encryption_enabled = true`.
     */
    public val authToken: Output<String>?
        get() = javaResource.authToken().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Strategy to use when updating the `auth_token`. Valid values are `SET`, `ROTATE`, and `DELETE`. Defaults to `ROTATE`.
     */
    public val authTokenUpdateStrategy: Output<String>?
        get() = javaResource.authTokenUpdateStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether minor version engine upgrades will be applied automatically to the underlying Cache Cluster instances during the maintenance window.
     * Only supported for engine type `"redis"` and if the engine version is 6 or higher.
     * Defaults to `true`.
     */
    public val autoMinorVersionUpgrade: Output<Boolean>
        get() = javaResource.autoMinorVersionUpgrade().applyValue({ args0 -> args0 })

    /**
     * Specifies whether a read-only replica will be automatically promoted to read/write primary if the existing primary fails. If enabled, `num_cache_clusters` must be greater than 1. Must be enabled for Redis (cluster mode enabled) replication groups. Defaults to `false`.
     */
    public val automaticFailoverEnabled: Output<Boolean>?
        get() = javaResource.automaticFailoverEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if cluster mode is enabled.
     */
    public val clusterEnabled: Output<Boolean>
        get() = javaResource.clusterEnabled().applyValue({ args0 -> args0 })

    /**
     * Address of the replication group configuration endpoint when cluster mode is enabled.
     */
    public val configurationEndpointAddress: Output<String>
        get() = javaResource.configurationEndpointAddress().applyValue({ args0 -> args0 })

    /**
     * Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to `true` when using r6gd nodes.
     */
    public val dataTieringEnabled: Output<Boolean>
        get() = javaResource.dataTieringEnabled().applyValue({ args0 -> args0 })

    /**
     * User-created description for the replication group. Must not be empty.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Name of the cache engine to be used for the clusters in this replication group. The only valid value is `redis`.
     */
    public val engine: Output<String>?
        get() = javaResource.engine().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Version number of the cache engine to be used for the cache clusters in this replication group.
     * If the version is 7 or higher, the major and minor version should be set, e.g., `7.2`.
     * If the version is 6, the major and minor version can be set, e.g., `6.2`,
     * or the minor version can be unspecified which will use the latest version at creation time, e.g., `6.x`.
     * Otherwise, specify the full version desired, e.g., `5.0.6`.
     * The actual engine version used is returned in the attribute `engine_version_actual`, see Attribute Reference below.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * Because ElastiCache pulls the latest minor or patch for a version, this attribute returns the running version of the cache engine.
     */
    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * The name of your final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster. If omitted, no final snapshot will be made.
     */
    public val finalSnapshotIdentifier: Output<String>?
        get() = javaResource.finalSnapshotIdentifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the global replication group to which this replication group should belong. If this parameter is specified, the replication group is added to the specified global replication group as a secondary replication group; otherwise, the replication group is not part of any global replication group. If `global_replication_group_id` is set, the `num_node_groups` parameter cannot be set.
     */
    public val globalReplicationGroupId: Output<String>
        get() = javaResource.globalReplicationGroupId().applyValue({ args0 -> args0 })

    /**
     * The IP version to advertise in the discovery protocol. Valid values are `ipv4` or `ipv6`.
     */
    public val ipDiscovery: Output<String>
        get() = javaResource.ipDiscovery().applyValue({ args0 -> args0 })

    /**
     * The ARN of the key that you wish to use if encrypting at rest. If not supplied, uses service managed encryption. Can be specified only if `at_rest_encryption_enabled = true`.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the destination and format of Redis [SLOWLOG](https://redis&#46;io/commands/slowlog) or Redis [Engine Log](https://docs&#46;aws&#46;amazon&#46;com/AmazonElastiCache/latest/red-ug/Log_Delivery&#46;html#Log_contents-engine-log)&#46; See the documentation on [Amazon ElastiCache](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log). See Log Delivery Configuration below for more details.
     */
    public val logDeliveryConfigurations: Output<List<ReplicationGroupLogDeliveryConfiguration>>?
        get() = javaResource.logDeliveryConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Specifies the weekly time range for when maintenance on the cache cluster is performed. The format is `ddd:hh24:mi-ddd:hh24:mi` (24H Clock UTC). The minimum maintenance window is a 60 minute period. Example: `sun:05:00-sun:09:00`
     */
    public val maintenanceWindow: Output<String>
        get() = javaResource.maintenanceWindow().applyValue({ args0 -> args0 })

    /**
     * Identifiers of all the nodes that are part of this replication group.
     */
    public val memberClusters: Output<List<String>>
        get() = javaResource.memberClusters().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Specifies whether to enable Multi-AZ Support for the replication group. If `true`, `automatic_failover_enabled` must also be enabled. Defaults to `false`.
     */
    public val multiAzEnabled: Output<Boolean>?
        get() = javaResource.multiAzEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IP versions for cache cluster connections. Valid values are `ipv4`, `ipv6` or `dual_stack`.
     */
    public val networkType: Output<String>
        get() = javaResource.networkType().applyValue({ args0 -> args0 })

    /**
     * Instance class to be used. See AWS documentation for information on [supported node types](https://docs&#46;aws&#46;amazon&#46;com/AmazonElastiCache/latest/red-ug/CacheNodes&#46;SupportedTypes&#46;html) and [guidance on selecting node types](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes-select-size.html). Required unless `global_replication_group_id` is set. Cannot be set if `global_replication_group_id` is set.
     */
    public val nodeType: Output<String>
        get() = javaResource.nodeType().applyValue({ args0 -> args0 })

    /**
     * ARN of an SNS topic to send ElastiCache notifications to. Example: `arn:aws:sns:us-east-1:012345678999:my_sns_topic`
     */
    public val notificationTopicArn: Output<String>?
        get() = javaResource.notificationTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of cache clusters (primary and replicas) this replication group will have. If Multi-AZ is enabled, the value of this parameter must be at least 2. Updates will occur before other modifications. Conflicts with `num_node_groups`. Defaults to `1`.
     */
    public val numCacheClusters: Output<Int>
        get() = javaResource.numCacheClusters().applyValue({ args0 -> args0 })

    /**
     * Number of node groups (shards) for this Redis replication group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     */
    public val numNodeGroups: Output<Int>
        get() = javaResource.numNodeGroups().applyValue({ args0 -> args0 })

    /**
     * Name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used. To enable "cluster mode", i.e., data sharding, use a parameter group that has the parameter `cluster-enabled` set to true.
     */
    public val parameterGroupName: Output<String>
        get() = javaResource.parameterGroupName().applyValue({ args0 -> args0 })

    /**
     * Port number on which each of the cache nodes will accept connections. For Memcache the default is 11211, and for Redis the default port is 6379.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of EC2 availability zones in which the replication group's cache clusters will be created. The order of the availability zones in the list is considered. The first item in the list will be the primary node. Ignored when updating.
     */
    public val preferredCacheClusterAzs: Output<List<String>>?
        get() = javaResource.preferredCacheClusterAzs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * (Redis only) Address of the endpoint for the primary node in the replication group, if the cluster mode is disabled.
     */
    public val primaryEndpointAddress: Output<String>
        get() = javaResource.primaryEndpointAddress().applyValue({ args0 -> args0 })

    /**
     * (Redis only) Address of the endpoint for the reader node in the replication group, if the cluster mode is disabled.
     */
    public val readerEndpointAddress: Output<String>
        get() = javaResource.readerEndpointAddress().applyValue({ args0 -> args0 })

    /**
     * Number of replica nodes in each node group.
     * Changing this number will trigger a resizing operation before other settings modifications.
     * Valid values are 0 to 5.
     */
    public val replicasPerNodeGroup: Output<Int>
        get() = javaResource.replicasPerNodeGroup().applyValue({ args0 -> args0 })

    /**
     * Replication group identifier. This parameter is stored as a lowercase string.
     * The following arguments are optional:
     */
    public val replicationGroupId: Output<String>
        get() = javaResource.replicationGroupId().applyValue({ args0 -> args0 })

    /**
     * IDs of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Names of one or more Amazon VPC security groups associated with this replication group. Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud.
     */
    public val securityGroupNames: Output<List<String>>
        get() = javaResource.securityGroupNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of ARNs that identify Redis RDB snapshot files stored in Amazon S3. The names object names cannot contain any commas.
     */
    public val snapshotArns: Output<List<String>>?
        get() = javaResource.snapshotArns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Name of a snapshot from which to restore data into the new node group. Changing the `snapshot_name` forces a new resource.
     */
    public val snapshotName: Output<String>?
        get() = javaResource.snapshotName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Number of days for which ElastiCache will retain automatic cache cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, then a snapshot that was taken today will be retained for 5 days before being deleted. If the value of `snapshot_retention_limit` is set to zero (0), backups are turned off. Please note that setting a `snapshot_retention_limit` is not supported on cache.t1.micro cache nodes
     */
    public val snapshotRetentionLimit: Output<Int>?
        get() = javaResource.snapshotRetentionLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Daily time range (in UTC) during which ElastiCache will begin taking a daily snapshot of your cache cluster. The minimum snapshot window is a 60 minute period. Example: `05:00-09:00`
     */
    public val snapshotWindow: Output<String>
        get() = javaResource.snapshotWindow().applyValue({ args0 -> args0 })

    /**
     * Name of the cache subnet group to be used for the replication group.
     */
    public val subnetGroupName: Output<String>
        get() = javaResource.subnetGroupName().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. Adding tags to this resource will add or overwrite any existing tags on the clusters in the replication group and not to the group itself. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whether to enable encryption in transit.
     */
    public val transitEncryptionEnabled: Output<Boolean>
        get() = javaResource.transitEncryptionEnabled().applyValue({ args0 -> args0 })

    /**
     * User Group ID to associate with the replication group. Only a maximum of one (1) user group ID is valid. **NOTE:** This argument _is_ a set because the AWS specification allows for multiple IDs. However, in practice, AWS only allows a maximum size of one.
     */
    public val userGroupIds: Output<List<String>>?
        get() = javaResource.userGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ReplicationGroupMapper : ResourceMapper<ReplicationGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.ReplicationGroup::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationGroup = ReplicationGroup(
        javaResource as
            com.pulumi.aws.elasticache.ReplicationGroup,
    )
}

/**
 * @see [ReplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationGroup].
 */
public suspend fun replicationGroup(
    name: String,
    block: suspend ReplicationGroupResourceBuilder.() -> Unit,
): ReplicationGroup {
    val builder = ReplicationGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationGroup(name: String): ReplicationGroup {
    val builder = ReplicationGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
