@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache Subnet Group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.elasticache.SubnetGroup;
 * import com.pulumi.aws.elasticache.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooVpc = new Vpc("fooVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .vpcId(fooVpc.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var bar = new SubnetGroup("bar", SubnetGroupArgs.builder()
 *             .subnetIds(fooSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache Subnet Groups using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/subnetGroup:SubnetGroup bar tf-test-cache-subnet
 * ```
 * @property description Description for the cache subnet group. Defaults to "Managed by Pulumi".
 * @property name Name for the cache subnet group. ElastiCache converts this name to lowercase.
 * @property subnetIds List of VPC Subnet IDs for the cache subnet group
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.SubnetGroupArgs =
        com.pulumi.aws.elasticache.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the cache subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("oikhoquilndceiqe")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the cache subnet group. ElastiCache converts this name to lowercase.
     */
    @JvmName("kmleexyhoeyfalwy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("aipvimwjqtsrumhq")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("cgxnydubilkdkrhg")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("uisubatkrirvnwmy")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tykaekuhbowmdkcd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the cache subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("nxouyohgulycxjsx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the cache subnet group. ElastiCache converts this name to lowercase.
     */
    @JvmName("nwtmwnhpkujtrkjp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("bkunthwtxhkperjg")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("fujhicudibsjjchd")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ckkagjvdrneinwpe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iejjehttbcskmpav")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
        tags = tags,
    )
}
