@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.UserArgs.builder
import com.pulumi.aws.elasticache.kotlin.inputs.UserAuthenticationModeArgs
import com.pulumi.aws.elasticache.kotlin.inputs.UserAuthenticationModeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache user resource.
 * > **Note:** All arguments including the username and passwords will be stored in the raw state as plain-text.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new User("test", UserArgs.builder()
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .userId("testUserId")
 *             .userName("testUserName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache users using the `user_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/user:User my_user userId1
 * ```
 * @property accessString Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
 * @property authenticationMode Denotes the user's authentication properties. Detailed below.
 * @property engine The current supported value is `REDIS`.
 * @property noPasswordRequired Indicates a password is not required for this user.
 * @property passwords Passwords used for this user. You can create up to two passwords for each user.
 * @property tags A list of tags to be added to this resource. A tag is a key-value pair.
 * @property userId The ID of the user.
 * @property userName The username of the user.
 * The following arguments are optional:
 */
public data class UserArgs(
    public val accessString: Output<String>? = null,
    public val authenticationMode: Output<UserAuthenticationModeArgs>? = null,
    public val engine: Output<String>? = null,
    public val noPasswordRequired: Output<Boolean>? = null,
    public val passwords: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userId: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.UserArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.UserArgs =
        com.pulumi.aws.elasticache.UserArgs.builder()
            .accessString(accessString?.applyValue({ args0 -> args0 }))
            .authenticationMode(
                authenticationMode?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .engine(engine?.applyValue({ args0 -> args0 }))
            .noPasswordRequired(noPasswordRequired?.applyValue({ args0 -> args0 }))
            .passwords(passwords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userId(userId?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var accessString: Output<String>? = null

    private var authenticationMode: Output<UserAuthenticationModeArgs>? = null

    private var engine: Output<String>? = null

    private var noPasswordRequired: Output<Boolean>? = null

    private var passwords: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userId: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     */
    @JvmName("hrxbafenvuyobhfw")
    public suspend fun accessString(`value`: Output<String>) {
        this.accessString = value
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("edjsihdebwhphlov")
    public suspend fun authenticationMode(`value`: Output<UserAuthenticationModeArgs>) {
        this.authenticationMode = value
    }

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("gicaxypqxyabhyae")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Indicates a password is not required for this user.
     */
    @JvmName("xyoevvstqjjouppo")
    public suspend fun noPasswordRequired(`value`: Output<Boolean>) {
        this.noPasswordRequired = value
    }

    /**
     * @param value Passwords used for this user. You can create up to two passwords for each user.
     */
    @JvmName("xxexscexwicrpqxm")
    public suspend fun passwords(`value`: Output<List<String>>) {
        this.passwords = value
    }

    @JvmName("aperjldpaevjmmtp")
    public suspend fun passwords(vararg values: Output<String>) {
        this.passwords = Output.all(values.asList())
    }

    /**
     * @param values Passwords used for this user. You can create up to two passwords for each user.
     */
    @JvmName("scgpplmtqkfdhoam")
    public suspend fun passwords(values: List<Output<String>>) {
        this.passwords = Output.all(values)
    }

    /**
     * @param value A list of tags to be added to this resource. A tag is a key-value pair.
     */
    @JvmName("abboykabyfvfquvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the user.
     */
    @JvmName("xifyammpdlhxsues")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value The username of the user.
     * The following arguments are optional:
     */
    @JvmName("ownjeirlwwtxtkos")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Access permissions string used for this user. See [Specifying Permissions Using an Access String](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html#Access-string) for more details.
     */
    @JvmName("tcuqyetthaeplpqj")
    public suspend fun accessString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessString = mapped
    }

    /**
     * @param value Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("ganrrbprsrttuqrk")
    public suspend fun authenticationMode(`value`: UserAuthenticationModeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param argument Denotes the user's authentication properties. Detailed below.
     */
    @JvmName("mochagbfoencluld")
    public suspend
    fun authenticationMode(argument: suspend UserAuthenticationModeArgsBuilder.() -> Unit) {
        val toBeMapped = UserAuthenticationModeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authenticationMode = mapped
    }

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("edfwvrkanaxyymtm")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Indicates a password is not required for this user.
     */
    @JvmName("kosglivlfnrrbiwb")
    public suspend fun noPasswordRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noPasswordRequired = mapped
    }

    /**
     * @param value Passwords used for this user. You can create up to two passwords for each user.
     */
    @JvmName("qvgaxifafdclhbyu")
    public suspend fun passwords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param values Passwords used for this user. You can create up to two passwords for each user.
     */
    @JvmName("kkhlvjreqalaejxs")
    public suspend fun passwords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwords = mapped
    }

    /**
     * @param value A list of tags to be added to this resource. A tag is a key-value pair.
     */
    @JvmName("uiuwhjbxxucubjuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A list of tags to be added to this resource. A tag is a key-value pair.
     */
    @JvmName("brwivjldgfiucixq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the user.
     */
    @JvmName("kamgewvvonukgbkm")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    /**
     * @param value The username of the user.
     * The following arguments are optional:
     */
    @JvmName("fnefobhserusegks")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        accessString = accessString,
        authenticationMode = authenticationMode,
        engine = engine,
        noPasswordRequired = noPasswordRequired,
        passwords = passwords,
        tags = tags,
        userId = userId,
        userName = userName,
    )
}
