@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [UserGroup].
 */
@PulumiTagMarker
public class UserGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGroupArgs = UserGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGroupArgsBuilder.() -> Unit) {
        val builder = UserGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserGroup {
        val builtJavaResource = com.pulumi.aws.elasticache.UserGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGroup(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache user group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .userId("testUserId")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var testUserGroup = new UserGroup("testUserGroup", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(testUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache user groups using the `user_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/userGroup:UserGroup my_user_group userGoupId1
 * ```
 *
 */
public class UserGroup internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.UserGroup,
) : KotlinCustomResource(javaResource, UserGroupMapper) {
    /**
     * The ARN that identifies the user group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The current supported value is `REDIS`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the user group.
     * The following arguments are optional:
     */
    public val userGroupId: Output<String>
        get() = javaResource.userGroupId().applyValue({ args0 -> args0 })

    /**
     * The list of user IDs that belong to the user group.
     */
    public val userIds: Output<List<String>>?
        get() = javaResource.userIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object UserGroupMapper : ResourceMapper<UserGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.UserGroup::class == javaResource::class

    override fun map(javaResource: Resource): UserGroup = UserGroup(
        javaResource as
            com.pulumi.aws.elasticache.UserGroup,
    )
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGroup].
 */
public suspend fun userGroup(name: String, block: suspend UserGroupResourceBuilder.() -> Unit):
    UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGroup(name: String): UserGroup {
    val builder = UserGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
