@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.UserGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache user group resource.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .userId("testUserId")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var testUserGroup = new UserGroup("testUserGroup", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(testUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache user groups using the `user_group_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/userGroup:UserGroup my_user_group userGoupId1
 * ```
 * @property engine The current supported value is `REDIS`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userGroupId The ID of the user group.
 * The following arguments are optional:
 * @property userIds The list of user IDs that belong to the user group.
 */
public data class UserGroupArgs(
    public val engine: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userGroupId: Output<String>? = null,
    public val userIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.UserGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.UserGroupArgs =
        com.pulumi.aws.elasticache.UserGroupArgs.builder()
            .engine(engine?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userGroupId(userGroupId?.applyValue({ args0 -> args0 }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UserGroupArgs].
 */
@PulumiTagMarker
public class UserGroupArgsBuilder internal constructor() {
    private var engine: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userGroupId: Output<String>? = null

    private var userIds: Output<List<String>>? = null

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("smvbkgdyjqvrjepo")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwdhtvyxsnymvnno")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the user group.
     * The following arguments are optional:
     */
    @JvmName("trpopyvyatvsrrpd")
    public suspend fun userGroupId(`value`: Output<String>) {
        this.userGroupId = value
    }

    /**
     * @param value The list of user IDs that belong to the user group.
     */
    @JvmName("ernrjjqjyeeifbub")
    public suspend fun userIds(`value`: Output<List<String>>) {
        this.userIds = value
    }

    @JvmName("mkwqossdohufhwtu")
    public suspend fun userIds(vararg values: Output<String>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values The list of user IDs that belong to the user group.
     */
    @JvmName("qycecdgomlucgblt")
    public suspend fun userIds(values: List<Output<String>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("qfbfuuijakhwvwju")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gfweuvplemcubqxf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qgeeeaurubkmfuas")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the user group.
     * The following arguments are optional:
     */
    @JvmName("tdhvrclnxoxfmyop")
    public suspend fun userGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupId = mapped
    }

    /**
     * @param value The list of user IDs that belong to the user group.
     */
    @JvmName("vwtcuuadsneqqnuk")
    public suspend fun userIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values The list of user IDs that belong to the user group.
     */
    @JvmName("elcusrobnhtyugxj")
    public suspend fun userIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    internal fun build(): UserGroupArgs = UserGroupArgs(
        engine = engine,
        tags = tags,
        userGroupId = userGroupId,
        userIds = userIds,
    )
}
