@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserGroupAssociation].
 */
@PulumiTagMarker
public class UserGroupAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserGroupAssociationArgs = UserGroupAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserGroupAssociationArgsBuilder.() -> Unit) {
        val builder = UserGroupAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UserGroupAssociation {
        val builtJavaResource = com.pulumi.aws.elasticache.UserGroupAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserGroupAssociation(builtJavaResource)
    }
}

/**
 * Associate an existing ElastiCache user and an existing user group.
 * > **NOTE:** The provider will detect changes in the `aws.elasticache.UserGroup` since `aws.elasticache.UserGroupAssociation` changes the user IDs associated with the user group. You can ignore these changes with the `ignore_changes` option as shown in the example.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import com.pulumi.aws.elasticache.UserGroupAssociation;
 * import com.pulumi.aws.elasticache.UserGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new User("default", UserArgs.builder()
 *             .userId("defaultUserID")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var exampleUserGroup = new UserGroup("exampleUserGroup", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(default_.userId())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userId("exampleUserID")
 *             .userName("exampleuser")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var exampleUserGroupAssociation = new UserGroupAssociation("exampleUserGroupAssociation", UserGroupAssociationArgs.builder()
 *             .userGroupId(exampleUserGroup.userGroupId())
 *             .userId(exampleUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache user group associations using the `user_group_id` and `user_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/userGroupAssociation:UserGroupAssociation example userGoupId1,userId
 * ```
 *
 */
public class UserGroupAssociation internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.UserGroupAssociation,
) : KotlinCustomResource(javaResource, UserGroupAssociationMapper) {
    /**
     * ID of the user group.
     */
    public val userGroupId: Output<String>
        get() = javaResource.userGroupId().applyValue({ args0 -> args0 })

    /**
     * ID of the user to associated with the user group.
     */
    public val userId: Output<String>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object UserGroupAssociationMapper : ResourceMapper<UserGroupAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.UserGroupAssociation::class == javaResource::class

    override fun map(javaResource: Resource): UserGroupAssociation = UserGroupAssociation(
        javaResource
            as com.pulumi.aws.elasticache.UserGroupAssociation,
    )
}

/**
 * @see [UserGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserGroupAssociation].
 */
public suspend fun userGroupAssociation(
    name: String,
    block: suspend UserGroupAssociationResourceBuilder.() -> Unit,
): UserGroupAssociation {
    val builder = UserGroupAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserGroupAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userGroupAssociation(name: String): UserGroupAssociation {
    val builder = UserGroupAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
