@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.UserGroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associate an existing ElastiCache user and an existing user group.
 * > **NOTE:** The provider will detect changes in the `aws.elasticache.UserGroup` since `aws.elasticache.UserGroupAssociation` changes the user IDs associated with the user group. You can ignore these changes with the `ignore_changes` option as shown in the example.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import com.pulumi.aws.elasticache.UserGroupAssociation;
 * import com.pulumi.aws.elasticache.UserGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new User("default", UserArgs.builder()
 *             .userId("defaultUserID")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var exampleUserGroup = new UserGroup("exampleUserGroup", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(default_.userId())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userId("exampleUserID")
 *             .userName("exampleuser")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var exampleUserGroupAssociation = new UserGroupAssociation("exampleUserGroupAssociation", UserGroupAssociationArgs.builder()
 *             .userGroupId(exampleUserGroup.userGroupId())
 *             .userId(exampleUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import ElastiCache user group associations using the `user_group_id` and `user_id`. For example:
 * ```sh
 *  $ pulumi import aws:elasticache/userGroupAssociation:UserGroupAssociation example userGoupId1,userId
 * ```
 * @property userGroupId ID of the user group.
 * @property userId ID of the user to associated with the user group.
 */
public data class UserGroupAssociationArgs(
    public val userGroupId: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.UserGroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.UserGroupAssociationArgs =
        com.pulumi.aws.elasticache.UserGroupAssociationArgs.builder()
            .userGroupId(userGroupId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserGroupAssociationArgs].
 */
@PulumiTagMarker
public class UserGroupAssociationArgsBuilder internal constructor() {
    private var userGroupId: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value ID of the user group.
     */
    @JvmName("fynykjwecsctuagj")
    public suspend fun userGroupId(`value`: Output<String>) {
        this.userGroupId = value
    }

    /**
     * @param value ID of the user to associated with the user group.
     */
    @JvmName("cleyhdujuftgolat")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value ID of the user group.
     */
    @JvmName("xegaivkhrewtqkbh")
    public suspend fun userGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupId = mapped
    }

    /**
     * @param value ID of the user to associated with the user group.
     */
    @JvmName("fgyqwnpkvhfwpjpr")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserGroupAssociationArgs = UserGroupAssociationArgs(
        userGroupId = userGroupId,
        userId = userId,
    )
}
