@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.ClusterLogDeliveryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
 * @property destinationType For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
 * @property logFormat Valid values are `json` or `text`
 * @property logType Valid values are  `slow-log` or `engine-log`. Max 1 of each.
 */
public data class ClusterLogDeliveryConfigurationArgs(
    public val destination: Output<String>,
    public val destinationType: Output<String>,
    public val logFormat: Output<String>,
    public val logType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.ClusterLogDeliveryConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.ClusterLogDeliveryConfigurationArgs =
        com.pulumi.aws.elasticache.inputs.ClusterLogDeliveryConfigurationArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 }))
            .destinationType(destinationType.applyValue({ args0 -> args0 }))
            .logFormat(logFormat.applyValue({ args0 -> args0 }))
            .logType(logType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterLogDeliveryConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterLogDeliveryConfigurationArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var destinationType: Output<String>? = null

    private var logFormat: Output<String>? = null

    private var logType: Output<String>? = null

    /**
     * @param value Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
     */
    @JvmName("jnklimqencesqtuf")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
     */
    @JvmName("ccjjrdofejcvhymo")
    public suspend fun destinationType(`value`: Output<String>) {
        this.destinationType = value
    }

    /**
     * @param value Valid values are `json` or `text`
     */
    @JvmName("gfsnyxjwwkptikdr")
    public suspend fun logFormat(`value`: Output<String>) {
        this.logFormat = value
    }

    /**
     * @param value Valid values are  `slow-log` or `engine-log`. Max 1 of each.
     */
    @JvmName("rexivvsetpvjlpbu")
    public suspend fun logType(`value`: Output<String>) {
        this.logType = value
    }

    /**
     * @param value Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
     */
    @JvmName("uqbkwyciyljfhpyy")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
     */
    @JvmName("qdnwqahiyimqspkg")
    public suspend fun destinationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationType = mapped
    }

    /**
     * @param value Valid values are `json` or `text`
     */
    @JvmName("wgamillgwcjslfvm")
    public suspend fun logFormat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logFormat = mapped
    }

    /**
     * @param value Valid values are  `slow-log` or `engine-log`. Max 1 of each.
     */
    @JvmName("ddewvdqbwwcpbmsg")
    public suspend fun logType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logType = mapped
    }

    internal fun build(): ClusterLogDeliveryConfigurationArgs = ClusterLogDeliveryConfigurationArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
        destinationType = destinationType ?: throw PulumiNullFieldException("destinationType"),
        logFormat = logFormat ?: throw PulumiNullFieldException("logFormat"),
        logType = logType ?: throw PulumiNullFieldException("logType"),
    )
}
