@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCluster.
 * @property arn
 * @property availabilityZone Availability Zone for the cache cluster.
 * @property cacheNodes List of node objects including `id`, `address`, `port`, `availability_zone` and `outpost_arn`.
 * Referenceable e.g., as `${data.aws_elasticache_cluster.bar.cache_nodes.0.address}`
 * @property clusterAddress (Memcached only) DNS name of the cache cluster without the port appended.
 * @property clusterId
 * @property configurationEndpoint (Memcached only) Configuration endpoint to allow host discovery.
 * @property engine Name of the cache engine.
 * @property engineVersion Version number of the cache engine.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipDiscovery The IP version advertised in the discovery protocol.
 * @property logDeliveryConfigurations Redis [SLOWLOG](https://redis&#46;io/commands/slowlog) or Redis [Engine Log](https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Log_Delivery.html#Log_contents-engine-log) delivery settings.
 * @property maintenanceWindow Specifies the weekly time range for when maintenance
 * on the cache cluster is performed.
 * @property networkType The IP versions for cache cluster connections.
 * @property nodeType The cluster node type.
 * @property notificationTopicArn An ARN of an
 * SNS topic that ElastiCache notifications get sent to.
 * @property numCacheNodes The number of cache nodes that the cache cluster has.
 * @property parameterGroupName Name of the parameter group associated with this cache cluster.
 * @property port The port number on which each of the cache nodes will
 * accept connections.
 * @property preferredOutpostArn The outpost ARN in which the cache cluster was created if created in outpost.
 * @property replicationGroupId The replication group to which this cache cluster belongs.
 * @property securityGroupIds List VPC security groups associated with the cache cluster.
 * @property snapshotRetentionLimit The number of days for which ElastiCache will
 * retain automatic cache cluster snapshots before deleting them.
 * @property snapshotWindow Daily time range (in UTC) during which ElastiCache will
 * begin taking a daily snapshot of the cache cluster.
 * @property subnetGroupName Name of the subnet group associated to the cache cluster.
 * @property tags Tags assigned to the resource
 */
public data class GetClusterResult(
    public val arn: String,
    public val availabilityZone: String,
    public val cacheNodes: List<GetClusterCacheNode>,
    public val clusterAddress: String,
    public val clusterId: String,
    public val configurationEndpoint: String,
    public val engine: String,
    public val engineVersion: String,
    public val id: String,
    public val ipDiscovery: String,
    public val logDeliveryConfigurations: List<GetClusterLogDeliveryConfiguration>,
    public val maintenanceWindow: String,
    public val networkType: String,
    public val nodeType: String,
    public val notificationTopicArn: String,
    public val numCacheNodes: Int,
    public val parameterGroupName: String,
    public val port: Int,
    public val preferredOutpostArn: String,
    public val replicationGroupId: String,
    public val securityGroupIds: List<String>,
    public val snapshotRetentionLimit: Int,
    public val snapshotWindow: String,
    public val subnetGroupName: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.GetClusterResult):
            GetClusterResult = GetClusterResult(
            arn = javaType.arn(),
            availabilityZone = javaType.availabilityZone(),
            cacheNodes = javaType.cacheNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticache.kotlin.outputs.GetClusterCacheNode.Companion.toKotlin(args0)
                })
            }),
            clusterAddress = javaType.clusterAddress(),
            clusterId = javaType.clusterId(),
            configurationEndpoint = javaType.configurationEndpoint(),
            engine = javaType.engine(),
            engineVersion = javaType.engineVersion(),
            id = javaType.id(),
            ipDiscovery = javaType.ipDiscovery(),
            logDeliveryConfigurations = javaType.logDeliveryConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticache.kotlin.outputs.GetClusterLogDeliveryConfiguration.Companion.toKotlin(args0)
                })
            }),
            maintenanceWindow = javaType.maintenanceWindow(),
            networkType = javaType.networkType(),
            nodeType = javaType.nodeType(),
            notificationTopicArn = javaType.notificationTopicArn(),
            numCacheNodes = javaType.numCacheNodes(),
            parameterGroupName = javaType.parameterGroupName(),
            port = javaType.port(),
            preferredOutpostArn = javaType.preferredOutpostArn(),
            replicationGroupId = javaType.replicationGroupId(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            snapshotRetentionLimit = javaType.snapshotRetentionLimit(),
            snapshotWindow = javaType.snapshotWindow(),
            subnetGroupName = javaType.subnetGroupName(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
