@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUser.
 * @property accessString String for what access a user possesses within the associated ElastiCache replication groups or clusters.
 * @property authenticationModes
 * @property engine
 * @property id The provider-assigned unique ID for this managed resource.
 * @property noPasswordRequired
 * @property passwords
 * @property userId Identifier for the user.
 * @property userName User name of the user.
 */
public data class GetUserResult(
    public val accessString: String? = null,
    public val authenticationModes: List<GetUserAuthenticationMode>? = null,
    public val engine: String? = null,
    public val id: String,
    public val noPasswordRequired: Boolean? = null,
    public val passwords: List<String>? = null,
    public val userId: String,
    public val userName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.GetUserResult): GetUserResult =
            GetUserResult(
                accessString = javaType.accessString().map({ args0 -> args0 }).orElse(null),
                authenticationModes = javaType.authenticationModes().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.elasticache.kotlin.outputs.GetUserAuthenticationMode.Companion.toKotlin(args0)
                    })
                }),
                engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                noPasswordRequired = javaType.noPasswordRequired().map({ args0 -> args0 }).orElse(null),
                passwords = javaType.passwords().map({ args0 -> args0 }),
                userId = javaType.userId(),
                userName = javaType.userName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
