@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination Name of either the CloudWatch Logs LogGroup or Kinesis Data Firehose resource.
 * @property destinationType For CloudWatch Logs use `cloudwatch-logs` or for Kinesis Data Firehose use `kinesis-firehose`.
 * @property logFormat Valid values are `json` or `text`
 * @property logType Valid values are  `slow-log` or `engine-log`. Max 1 of each.
 */
public data class ReplicationGroupLogDeliveryConfiguration(
    public val destination: String,
    public val destinationType: String,
    public val logFormat: String,
    public val logType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.ReplicationGroupLogDeliveryConfiguration):
            ReplicationGroupLogDeliveryConfiguration = ReplicationGroupLogDeliveryConfiguration(
            destination = javaType.destination(),
            destinationType = javaType.destinationType(),
            logFormat = javaType.logFormat(),
            logType = javaType.logType(),
        )
    }
}
