@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property passwordCount
 * @property passwords Specifies the passwords to use for authentication if `type` is set to `password`.
 * @property type Specifies the authentication type. Possible options are: `password`, `no-password-required` or `iam`.
 */
public data class UserAuthenticationMode(
    public val passwordCount: Int? = null,
    public val passwords: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.UserAuthenticationMode):
            UserAuthenticationMode = UserAuthenticationMode(
            passwordCount = javaType.passwordCount().map({ args0 -> args0 }).orElse(null),
            passwords = javaType.passwords().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
