@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.ApplicationArgs.builder
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.ApplicationAppversionLifecycleArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.ApplicationAppversionLifecycleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Beanstalk Application Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * This resource creates an application that has one configuration template named
 * `default`, and no application versions
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.inputs.ApplicationAppversionLifecycleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .description("tf-test-desc")
 *             .appversionLifecycle(ApplicationAppversionLifecycleArgs.builder()
 *                 .serviceRole(aws_iam_role.beanstalk_service().arn())
 *                 .maxCount(128)
 *                 .deleteSourceFromS3(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Elastic Beanstalk Applications using the `name`. For example:
 * ```sh
 *  $ pulumi import aws:elasticbeanstalk/application:Application tf_test tf-test-name
 * ```
 * @property appversionLifecycle
 * @property description Short description of the application
 * @property name The name of the application, must be unique within your account
 * @property tags Key-value map of tags for the Elastic Beanstalk Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationArgs(
    public val appversionLifecycle: Output<ApplicationAppversionLifecycleArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.ApplicationArgs =
        com.pulumi.aws.elasticbeanstalk.ApplicationArgs.builder()
            .appversionLifecycle(
                appversionLifecycle?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var appversionLifecycle: Output<ApplicationAppversionLifecycleArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("ytjmhwofdgbbtnby")
    public suspend fun appversionLifecycle(`value`: Output<ApplicationAppversionLifecycleArgs>) {
        this.appversionLifecycle = value
    }

    /**
     * @param value Short description of the application
     */
    @JvmName("hjvnnobpffpcsxke")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the application, must be unique within your account
     */
    @JvmName("ydavgcjswrhwluxd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qvjqmpcgqorsuybj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ldcdtulgjjwmiery")
    public suspend fun appversionLifecycle(`value`: ApplicationAppversionLifecycleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appversionLifecycle = mapped
    }

    /**
     * @param argument
     */
    @JvmName("coludqdoslmfeelw")
    public suspend
    fun appversionLifecycle(argument: suspend ApplicationAppversionLifecycleArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationAppversionLifecycleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.appversionLifecycle = mapped
    }

    /**
     * @param value Short description of the application
     */
    @JvmName("alpkinychfeeysrr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the application, must be unique within your account
     */
    @JvmName("vwevcurmiyeiflxo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wehesbhssllbxdxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Elastic Beanstalk Application. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jcluwsmhgfjrfjni")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        appversionLifecycle = appversionLifecycle,
        description = description,
        name = name,
        tags = tags,
    )
}
